/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.FrequencyParameter;
import com.espertech.esper.type.IntParameter;
import com.espertech.esper.type.ListParameter;
import com.espertech.esper.type.NumberSetParameter;
import com.espertech.esper.type.RangeParameter;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNumberSetList
extends ExprNodeBase
implements ExprEvaluator {
    private static final Log log = LogFactory.getLog(ExprNumberSetList.class);
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = 4941618470342360450L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        String delimiter = "";
        buffer.append('[');
        Iterator<ExprNode> it = Arrays.asList(this.getChildNodes()).iterator();
        do {
            ExprNode expr = it.next();
            buffer.append(delimiter);
            buffer.append(expr.toExpressionString());
            delimiter = ",";
        } while (it.hasNext());
        buffer.append(']');
        return buffer.toString();
    }

    @Override
    public boolean isConstantResult() {
        for (ExprNode child : this.getChildNodes()) {
            if (child.isConstantResult()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprNumberSetList;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        for (ExprEvaluator child : this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes())) {
            Class type = child.getType();
            if (type == FrequencyParameter.class || type == RangeParameter.class || JavaClassHelper.isNumericNonFP(type)) continue;
            throw new ExprValidationException("Frequency operator requires an integer-type parameter");
        }
    }

    @Override
    public Class getType() {
        return ListParameter.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayList<NumberSetParameter> parameters = new ArrayList<NumberSetParameter>();
        for (ExprEvaluator child : this.evaluators) {
            Object value = child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (value == null) {
                log.info((Object)"Null value returned for lower bounds value in list parameter, skipping parameter");
                continue;
            }
            if (value instanceof FrequencyParameter || value instanceof RangeParameter) {
                parameters.add((NumberSetParameter)value);
                continue;
            }
            int intValue = ((Number)value).intValue();
            parameters.add(new IntParameter(intValue));
        }
        if (parameters.isEmpty()) {
            log.warn((Object)"Empty list of values in list parameter, using upper bounds");
            parameters.add(new IntParameter(Integer.MAX_VALUE));
        }
        return new ListParameter(parameters);
    }
}

