/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.hook.AggregationFunctionFactory;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationValidationContext;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprPlugInAggFunctionFactory;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;

public class ExprPlugInAggFunctionFactoryNode
extends ExprAggregateNodeBase {
    private static final long serialVersionUID = 65459875362787079L;
    private transient AggregationFunctionFactory aggregationFunctionFactory;
    private final String functionName;

    public ExprPlugInAggFunctionFactoryNode(boolean distinct, AggregationFunctionFactory aggregationFunctionFactory, String functionName) {
        super(distinct);
        this.aggregationFunctionFactory = aggregationFunctionFactory;
        this.functionName = functionName;
        aggregationFunctionFactory.setFunctionName(functionName);
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        Class[] parameterTypes = new Class[this.getChildNodes().length];
        Object[] constant = new Object[this.getChildNodes().length];
        boolean[] isConstant = new boolean[this.getChildNodes().length];
        ExprNode[] expressions = new ExprNode[this.getChildNodes().length];
        int count = 0;
        boolean hasDataWindows = true;
        for (ExprNode child : this.getChildNodes()) {
            if (child.isConstantResult()) {
                isConstant[count] = true;
                constant[count] = child.getExprEvaluator().evaluate(null, true, validationContext.getExprEvaluatorContext());
            }
            parameterTypes[count] = child.getExprEvaluator().getType();
            expressions[count] = child;
            ++count;
            if (ExprNodeUtility.hasRemoveStream(child, validationContext.getStreamTypeService())) continue;
            hasDataWindows = false;
        }
        AggregationValidationContext context = new AggregationValidationContext(parameterTypes, isConstant, constant, super.isDistinct(), hasDataWindows, expressions);
        try {
            this.aggregationFunctionFactory.validate(context);
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Plug-in aggregation function factory '" + this.functionName + "' failed validation: " + ex.getMessage());
        }
        Class childType = null;
        if (this.getChildNodes().length > 0) {
            childType = this.getChildNodes()[0].getExprEvaluator().getType();
        }
        return new ExprPlugInAggFunctionFactory(this.aggregationFunctionFactory, super.isDistinct(), childType);
    }

    @Override
    public String getAggregationFunctionName() {
        return this.functionName;
    }

    @Override
    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        if (!(node instanceof ExprPlugInAggFunctionFactoryNode)) {
            return false;
        }
        ExprPlugInAggFunctionFactoryNode other = (ExprPlugInAggFunctionFactoryNode)node;
        return other.getAggregationFunctionName().equals(this.getAggregationFunctionName());
    }
}

