/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationSupport;
import com.espertech.esper.epl.agg.service.AggregationValidationContext;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprPlugInAggFunctionNodeFactory;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;

public class ExprPlugInAggFunctionNode
extends ExprAggregateNodeBase {
    private transient AggregationSupport aggregationSupport;
    private static final long serialVersionUID = 4512085880102791194L;

    public ExprPlugInAggFunctionNode(boolean distinct, AggregationSupport aggregationSupport, String functionName) {
        super(distinct);
        this.aggregationSupport = aggregationSupport;
        aggregationSupport.setFunctionName(functionName);
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        Class[] parameterTypes = new Class[this.getChildNodes().length];
        Object[] constant = new Object[this.getChildNodes().length];
        boolean[] isConstant = new boolean[this.getChildNodes().length];
        ExprNode[] expressions = new ExprNode[this.getChildNodes().length];
        int count = 0;
        boolean hasDataWindows = true;
        for (ExprNode child : this.getChildNodes()) {
            if (child.isConstantResult()) {
                isConstant[count] = true;
                constant[count] = child.getExprEvaluator().evaluate(null, true, validationContext.getExprEvaluatorContext());
            }
            parameterTypes[count] = child.getExprEvaluator().getType();
            expressions[count] = child;
            ++count;
            if (ExprNodeUtility.hasRemoveStream(child, validationContext.getStreamTypeService())) continue;
            hasDataWindows = false;
        }
        AggregationValidationContext context = new AggregationValidationContext(parameterTypes, isConstant, constant, super.isDistinct(), hasDataWindows, expressions);
        try {
            this.aggregationSupport.validate(context);
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Plug-in aggregation function '" + this.aggregationSupport.getFunctionName() + "' failed validation: " + ex.getMessage());
        }
        Class childType = null;
        if (this.getChildNodes().length > 0) {
            childType = this.getChildNodes()[0].getExprEvaluator().getType();
        }
        return new ExprPlugInAggFunctionNodeFactory(this.aggregationSupport, super.isDistinct(), childType);
    }

    @Override
    public String getAggregationFunctionName() {
        return this.aggregationSupport.getFunctionName();
    }

    @Override
    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        if (!(node instanceof ExprPlugInAggFunctionNode)) {
            return false;
        }
        ExprPlugInAggFunctionNode other = (ExprPlugInAggFunctionNode)node;
        return other.getAggregationFunctionName().equals(this.getAggregationFunctionName());
    }
}

