/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.ConfigurationPlugInSingleRowFunction;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.util.ExpressionReturnType;
import com.espertech.esper.epl.core.EngineImportSingleRowDesc;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrapFactory;
import com.espertech.esper.epl.expression.ExprChainedSpec;
import com.espertech.esper.epl.expression.ExprDotEval;
import com.espertech.esper.epl.expression.ExprDotEvalStaticMethod;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInputStatic;
import com.espertech.esper.epl.expression.ExprDotNodeUtility;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprFilterOptimizableNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeContextPropertiesVisitor;
import com.espertech.esper.epl.expression.ExprNodeInnerNodeProvider;
import com.espertech.esper.epl.expression.ExprNodeUtilMethodDesc;
import com.espertech.esper.epl.expression.ExprNodeUtilResolveExceptionHandlerDefault;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprNodeVisitor;
import com.espertech.esper.epl.expression.ExprNodeVisitorWithParent;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.filter.FilterSpecLookupable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExprPlugInSingleRowNode
extends ExprNodeBase
implements ExprNodeInnerNodeProvider,
ExprFilterOptimizableNode {
    private static final long serialVersionUID = 2485214890449563098L;
    private final String functionName;
    private final Class clazz;
    private final List<ExprChainedSpec> chainSpec;
    private final EngineImportSingleRowDesc config;
    private transient boolean isReturnsConstantResult;
    private transient ExprEvaluator evaluator;

    public ExprPlugInSingleRowNode(String functionName, Class clazz, List<ExprChainedSpec> chainSpec, EngineImportSingleRowDesc config) {
        this.functionName = functionName;
        this.clazz = clazz;
        this.chainSpec = chainSpec;
        this.config = config;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    public List<ExprChainedSpec> getChainSpec() {
        return this.chainSpec;
    }

    @Override
    public boolean isConstantResult() {
        return this.isReturnsConstantResult;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public boolean getFilterLookupEligible() {
        ExprNodeContextPropertiesVisitor visitor = new ExprNodeContextPropertiesVisitor();
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
        return !visitor.isFound() && this.config.getFilterOptimizable() == ConfigurationPlugInSingleRowFunction.FilterOptimizable.ENABLED && this.chainSpec.size() == 1 && !this.isReturnsConstantResult;
    }

    @Override
    public FilterSpecLookupable getFilterLookupable() {
        ExprDotEvalStaticMethod eval = (ExprDotEvalStaticMethod)this.evaluator;
        return new FilterSpecLookupable(this.toExpressionString(), eval, this.evaluator.getType());
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        ExprNodeUtility.toExpressionString(this.chainSpec, buffer, false, this.functionName);
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprPlugInSingleRowNode)) {
            return false;
        }
        ExprPlugInSingleRowNode other = (ExprPlugInSingleRowNode)node;
        if (other.chainSpec.size() != this.chainSpec.size()) {
            return false;
        }
        for (int i = 0; i < this.chainSpec.size(); ++i) {
            if (this.chainSpec.get(i).equals(other.chainSpec.get(i))) continue;
            return false;
        }
        return other.clazz == this.clazz && other.functionName.endsWith(this.functionName);
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        ExprNodeUtility.validate(this.chainSpec, validationContext);
        ArrayList<ExprChainedSpec> chainList = new ArrayList<ExprChainedSpec>(this.chainSpec);
        ExprChainedSpec firstItem = (ExprChainedSpec)chainList.remove(0);
        boolean allowWildcard = validationContext.getStreamTypeService().getEventTypes().length == 1;
        EventType streamZeroType = null;
        if (validationContext.getStreamTypeService().getEventTypes().length > 0) {
            streamZeroType = validationContext.getStreamTypeService().getEventTypes()[0];
        }
        final ExprNodeUtilMethodDesc staticMethodDesc = ExprNodeUtility.resolveMethodAllowWildcardAndStream(this.clazz.getName(), null, firstItem.getName(), firstItem.getParameters(), validationContext.getMethodResolutionService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), allowWildcard, streamZeroType, new ExprNodeUtilResolveExceptionHandlerDefault(firstItem.getName(), true), this.functionName);
        boolean allowValueCache = true;
        if (this.config.getValueCache() == ConfigurationPlugInSingleRowFunction.ValueCache.DISABLED) {
            this.isReturnsConstantResult = false;
            allowValueCache = false;
        } else if (this.config.getValueCache() == ConfigurationPlugInSingleRowFunction.ValueCache.CONFIGURED) {
            this.isReturnsConstantResult = validationContext.getMethodResolutionService().isUdfCache() && staticMethodDesc.isAllConstants() && chainList.isEmpty();
            allowValueCache = validationContext.getMethodResolutionService().isUdfCache();
        } else if (this.config.getValueCache() == ConfigurationPlugInSingleRowFunction.ValueCache.ENABLED) {
            this.isReturnsConstantResult = staticMethodDesc.isAllConstants() && chainList.isEmpty();
        } else {
            throw new IllegalStateException("Invalid value cache code " + (Object)((Object)this.config.getValueCache()));
        }
        ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(staticMethodDesc.getReflectionMethod(), validationContext.getEventAdapterService(), chainList);
        ExpressionReturnType typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : ExpressionReturnType.singleValue(staticMethodDesc.getReflectionMethod().getReturnType());
        ExprDotEval[] eval = ExprDotNodeUtility.getChainEvaluators(typeInfo, chainList, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic()).getChainWithUnpack();
        this.evaluator = new ExprDotEvalStaticMethod(validationContext.getStatementName(), this.clazz.getName(), staticMethodDesc.getFastMethod(), staticMethodDesc.getChildEvals(), allowValueCache && staticMethodDesc.isAllConstants(), optionalLambdaWrap, eval, this.config.isRethrowExceptions(), null);
        if (this.isReturnsConstantResult) {
            final Object result = this.evaluator.evaluate(null, true, null);
            this.evaluator = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return result;
                }

                @Override
                public Class getType() {
                    return staticMethodDesc.getFastMethod().getReturnType();
                }

                @Override
                public Map<String, Object> getEventType() throws ExprValidationException {
                    return null;
                }
            };
        }
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec, this);
    }

    @Override
    public void replaceUnlistedChildNode(ExprNode nodeToReplace, ExprNode newNode) {
        ExprNodeUtility.replaceChainChildNode(nodeToReplace, newNode, this.chainSpec);
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return ExprNodeUtility.collectChainParameters(this.chainSpec);
    }
}

