/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccess;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccessGetter;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;

public class ExprPreviousMatchRecognizeNode
extends ExprNodeBase
implements ExprEvaluator {
    private static final long serialVersionUID = 0L;
    private Class resultType;
    private int streamNumber;
    private Integer constantIndexNumber;
    private transient RegexPartitionStateRandomAccessGetter getter;
    private transient ExprEvaluator evaluator;
    private int assignedIndex;

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Match-Recognize Previous expression must have 2 child nodes");
        }
        if (!(this.getChildNodes()[0] instanceof ExprIdentNode)) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an property identifier as the first parameter");
        }
        if (!this.getChildNodes()[1].isConstantResult() || !JavaClassHelper.isNumericNonFP(this.getChildNodes()[1].getExprEvaluator().getType())) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an integer index parameter or expression as the second parameter");
        }
        ExprNode constantNode = this.getChildNodes()[1];
        Object value = constantNode.getExprEvaluator().evaluate(null, false, validationContext.getExprEvaluatorContext());
        if (!(value instanceof Number)) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an integer index parameter or expression as the second parameter");
        }
        this.constantIndexNumber = ((Number)value).intValue();
        ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes()[0];
        this.streamNumber = identNode.getStreamId();
        this.evaluator = this.getChildNodes()[0].getExprEvaluator();
        this.resultType = this.evaluator.getType();
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    public Integer getConstantIndexNumber() {
        if (this.constantIndexNumber == null) {
            ExprNode constantNode = this.getChildNodes()[1];
            Object value = constantNode.getExprEvaluator().evaluate(null, false, null);
            this.constantIndexNumber = ((Number)value).intValue();
        }
        return this.constantIndexNumber;
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        RegexPartitionStateRandomAccess access = this.getter.getAccessor();
        EventBean substituteEvent = access.getPreviousEvent(this.assignedIndex);
        if (substituteEvent == null) {
            return null;
        }
        EventBean originalEvent = eventsPerStream[this.streamNumber];
        eventsPerStream[this.streamNumber] = substituteEvent;
        Object evalResult = this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        eventsPerStream[this.streamNumber] = originalEvent;
        return evalResult;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("prev(");
        buffer.append(this.getChildNodes()[0].toExpressionString());
        buffer.append(',');
        buffer.append(this.getChildNodes()[1].toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprPreviousMatchRecognizeNode;
    }

    public void setGetter(RegexPartitionStateRandomAccessGetter getter) {
        this.getter = getter;
    }

    public void setAssignedIndex(int assignedIndex) {
        this.assignedIndex = assignedIndex;
    }
}

