/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import java.util.Map;

public class ExprPriorNode
extends ExprNodeBase
implements ExprEvaluator {
    private Class resultType;
    private int streamNumber;
    private int constantIndexNumber;
    private transient ExprPriorEvalStrategy priorStrategy;
    private transient ExprEvaluator innerEvaluator;
    private static final long serialVersionUID = -2115346817501589366L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public int getConstantIndexNumber() {
        return this.constantIndexNumber;
    }

    public void setPriorStrategy(ExprPriorEvalStrategy priorStrategy) {
        this.priorStrategy = priorStrategy;
    }

    public ExprEvaluator getInnerEvaluator() {
        return this.innerEvaluator;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Prior node must have 2 child nodes");
        }
        if (!this.getChildNodes()[0].isConstantResult()) {
            throw new ExprValidationException("Prior function requires an integer index parameter");
        }
        ExprNode constantNode = this.getChildNodes()[0];
        if (constantNode.getExprEvaluator().getType() != Integer.class) {
            throw new ExprValidationException("Prior function requires an integer index parameter");
        }
        Object value = constantNode.getExprEvaluator().evaluate(null, false, validationContext.getExprEvaluatorContext());
        this.constantIndexNumber = ((Number)value).intValue();
        this.innerEvaluator = this.getChildNodes()[1].getExprEvaluator();
        if (this.getChildNodes()[1] instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes()[1];
            this.streamNumber = identNode.getStreamId();
            this.resultType = this.innerEvaluator.getType();
        } else if (this.getChildNodes()[1] instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode streamNode = (ExprStreamUnderlyingNode)this.getChildNodes()[1];
            this.streamNumber = streamNode.getStreamId();
            this.resultType = this.innerEvaluator.getType();
        } else {
            throw new ExprValidationException("Previous function requires an event property as parameter");
        }
        if (validationContext.getViewResourceDelegate() == null) {
            throw new ExprValidationException("Prior function cannot be used in this context");
        }
        validationContext.getViewResourceDelegate().addPriorNodeRequest(this);
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.priorStrategy.evaluate(eventsPerStream, isNewData, exprEvaluatorContext, this.streamNumber, this.innerEvaluator, this.constantIndexNumber);
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("prior(");
        buffer.append(this.getChildNodes()[0].toExpressionString());
        buffer.append(',');
        buffer.append(this.getChildNodes()[1].toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprPriorNode;
    }
}

