/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ExprRegexpNode
extends ExprNodeBase
implements ExprEvaluator {
    private final boolean isNot;
    private Pattern pattern;
    private boolean isNumericValue;
    private boolean isConstantPattern;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -837177267278295664L;

    public ExprRegexpNode(boolean not) {
        this.isNot = not;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("The regexp operator requires 2 child expressions");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class patternChildType = this.evaluators[1].getType();
        if (patternChildType != String.class) {
            throw new ExprValidationException("The regexp operator requires a String-type pattern expression");
        }
        if (this.getChildNodes()[1].isConstantResult()) {
            this.isConstantPattern = true;
        }
        Class evalChildType = this.evaluators[0].getType();
        this.isNumericValue = JavaClassHelper.isNumeric(evalChildType);
        if (evalChildType != String.class && !this.isNumericValue) {
            throw new ExprValidationException("The regexp operator requires a String or numeric type left-hand expression");
        }
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object evalValue;
        String patternText;
        if (this.pattern == null) {
            patternText = (String)this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternText == null) {
                return null;
            }
            try {
                this.pattern = Pattern.compile(patternText);
            }
            catch (PatternSyntaxException ex) {
                throw new EPException("Error compiling regex pattern '" + patternText + '\'', ex);
            }
        }
        if (!this.isConstantPattern) {
            patternText = (String)this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternText == null) {
                return null;
            }
            try {
                this.pattern = Pattern.compile(patternText);
            }
            catch (PatternSyntaxException ex) {
                throw new EPException("Error compiling regex pattern '" + patternText + '\'', ex);
            }
        }
        if ((evalValue = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext)) == null) {
            return null;
        }
        if (this.isNumericValue) {
            evalValue = evalValue.toString();
        }
        Boolean result = this.pattern.matcher((CharSequence)evalValue).matches();
        if (this.isNot) {
            return result == false;
        }
        return result;
    }

    @Override
    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprRegexpNode)) {
            return false;
        }
        ExprRegexpNode other = (ExprRegexpNode)node_;
        return this.isNot == other.isNot;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes()[0].toExpressionString());
        if (this.isNot) {
            buffer.append(" not");
        }
        buffer.append(" regexp ");
        buffer.append(this.getChildNodes()[1].toExpressionString());
        return buffer.toString();
    }

    public boolean isNot() {
        return this.isNot;
    }
}

