/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ExprRelationalOpAllAnyNode
extends ExprNodeBase
implements ExprEvaluator {
    private final RelationalOpEnum relationalOpEnum;
    private final boolean isAll;
    private boolean hasCollectionOrArray;
    private transient RelationalOpEnum.Computer computer;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -9212002972361997109L;

    public ExprRelationalOpAllAnyNode(RelationalOpEnum relationalOpEnum, boolean isAll) {
        this.relationalOpEnum = relationalOpEnum;
        this.isAll = isAll;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    public boolean isAll() {
        return this.isAll;
    }

    public RelationalOpEnum getRelationalOpEnum() {
        return this.relationalOpEnum;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class coercionType;
        if (this.getChildNodes().length < 1) {
            throw new IllegalStateException("Group relational op node must have 1 or more child nodes");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class typeOne = JavaClassHelper.getBoxedType(this.evaluators[0].getType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        ArrayList<Class> comparedTypes = new ArrayList<Class>();
        comparedTypes.add(typeOne);
        this.hasCollectionOrArray = false;
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            Class propType = this.evaluators[i + 1].getType();
            if (propType.isArray()) {
                this.hasCollectionOrArray = true;
                if (propType.getComponentType() == Object.class) continue;
                comparedTypes.add(propType.getComponentType());
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Collection.class)) {
                this.hasCollectionOrArray = true;
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Map.class)) {
                this.hasCollectionOrArray = true;
                continue;
            }
            comparedTypes.add(propType);
        }
        try {
            coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        if (coercionType != String.class && !JavaClassHelper.isNumeric(coercionType)) {
            throw new ExprValidationException("Implicit conversion from datatype '" + coercionType.getSimpleName() + "' to numeric is not allowed");
        }
        this.computer = this.relationalOpEnum.getComputer(coercionType, coercionType, coercionType);
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.getChildNodes().length == 1) {
            return false;
        }
        Object valueLeft = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        int len = this.getChildNodes().length - 1;
        if (this.hasCollectionOrArray) {
            boolean hasNonNullRow = false;
            boolean hasRows = false;
            for (int i = 1; i <= len; ++i) {
                Object valueRight = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueRight == null) continue;
                if (valueRight instanceof Collection) {
                    Collection coll = (Collection)valueRight;
                    hasRows = true;
                    for (Object item : coll) {
                        if (!(item instanceof Number)) {
                            if (!this.isAll || item != null) continue;
                            return null;
                        }
                        hasNonNullRow = true;
                        if (valueLeft == null) continue;
                        if (this.isAll) {
                            if (this.computer.compare(valueLeft, item)) continue;
                            return false;
                        }
                        if (!this.computer.compare(valueLeft, item)) continue;
                        return true;
                    }
                    continue;
                }
                if (valueRight instanceof Map) {
                    Map coll = (Map)valueRight;
                    hasRows = true;
                    for (Object item : coll.keySet()) {
                        if (!(item instanceof Number)) {
                            if (!this.isAll || item != null) continue;
                            return null;
                        }
                        hasNonNullRow = true;
                        if (valueLeft == null) continue;
                        if (this.isAll) {
                            if (this.computer.compare(valueLeft, item)) continue;
                            return false;
                        }
                        if (!this.computer.compare(valueLeft, item)) continue;
                        return true;
                    }
                    continue;
                }
                if (valueRight.getClass().isArray()) {
                    hasRows = true;
                    int arrayLength = Array.getLength(valueRight);
                    for (int index = 0; index < arrayLength; ++index) {
                        Object item;
                        item = Array.get(valueRight, index);
                        if (item == null) {
                            if (!this.isAll) continue;
                            return null;
                        }
                        hasNonNullRow = true;
                        if (valueLeft == null) continue;
                        if (this.isAll) {
                            if (this.computer.compare(valueLeft, item)) continue;
                            return false;
                        }
                        if (!this.computer.compare(valueLeft, item)) continue;
                        return true;
                    }
                    continue;
                }
                if (!(valueRight instanceof Number)) {
                    if (!this.isAll) continue;
                    return null;
                }
                hasNonNullRow = true;
                if (this.isAll) {
                    if (this.computer.compare(valueLeft, valueRight)) continue;
                    return false;
                }
                if (!this.computer.compare(valueLeft, valueRight)) continue;
                return true;
            }
            if (this.isAll) {
                if (!hasRows) {
                    return true;
                }
                if (!hasNonNullRow || valueLeft == null) {
                    return null;
                }
                return true;
            }
            if (!hasRows) {
                return false;
            }
            if (!hasNonNullRow || valueLeft == null) {
                return null;
            }
            return false;
        }
        boolean hasNonNullRow = false;
        boolean hasRows = false;
        for (int i = 1; i <= len; ++i) {
            Object valueRight = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            hasRows = true;
            if (valueRight != null) {
                hasNonNullRow = true;
            } else if (this.isAll) {
                return null;
            }
            if (valueRight == null || valueLeft == null) continue;
            if (this.isAll) {
                if (this.computer.compare(valueLeft, valueRight)) continue;
                return false;
            }
            if (!this.computer.compare(valueLeft, valueRight)) continue;
            return true;
        }
        if (this.isAll) {
            if (!hasRows) {
                return true;
            }
            if (!hasNonNullRow || valueLeft == null) {
                return null;
            }
            return true;
        }
        if (!hasRows) {
            return false;
        }
        if (!hasNonNullRow || valueLeft == null) {
            return null;
        }
        return false;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes()[0].toExpressionString());
        buffer.append(" ");
        buffer.append(this.relationalOpEnum.getExpressionText());
        buffer.append(" ");
        if (this.isAll) {
            buffer.append("all");
        } else {
            buffer.append("any");
        }
        buffer.append("(");
        String delimiter = "";
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            buffer.append(delimiter);
            buffer.append(this.getChildNodes()[i + 1].toExpressionString());
            delimiter = ",";
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprRelationalOpAllAnyNode)) {
            return false;
        }
        ExprRelationalOpAllAnyNode other = (ExprRelationalOpAllAnyNode)node;
        return other.relationalOpEnum == this.relationalOpEnum && other.isAll == this.isAll;
    }
}

