/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprRelationalOpNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;

public class ExprRelationalOpNodeImpl
extends ExprNodeBase
implements ExprEvaluator,
ExprRelationalOpNode {
    private final RelationalOpEnum relationalOpEnum;
    private transient RelationalOpEnum.Computer computer;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -6170161542681634598L;

    public ExprRelationalOpNodeImpl(RelationalOpEnum relationalOpEnum) {
        this.relationalOpEnum = relationalOpEnum;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public RelationalOpEnum getRelationalOpEnum() {
        return this.relationalOpEnum;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new IllegalStateException("Relational op node does not have exactly 2 child nodes");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class typeOne = JavaClassHelper.getBoxedType(this.evaluators[0].getType());
        Class typeTwo = JavaClassHelper.getBoxedType(this.evaluators[1].getType());
        if (typeOne != String.class || typeTwo != String.class) {
            if (!JavaClassHelper.isNumeric(typeOne)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
            }
            if (!JavaClassHelper.isNumeric(typeTwo)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
            }
        }
        Class compareType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        this.computer = this.relationalOpEnum.getComputer(compareType, typeOne, typeTwo);
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueLeft = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueLeft == null) {
            return null;
        }
        Object valueRight = this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueRight == null) {
            return null;
        }
        return this.computer.compare(valueLeft, valueRight);
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes()[0].toExpressionString());
        buffer.append(this.relationalOpEnum.getExpressionText());
        buffer.append(this.getChildNodes()[1].toExpressionString());
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprRelationalOpNodeImpl)) {
            return false;
        }
        ExprRelationalOpNodeImpl other = (ExprRelationalOpNodeImpl)node;
        return other.relationalOpEnum == this.relationalOpEnum;
    }
}

