/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprSubselectStrategy;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ExprSubselectNode
extends ExprNodeBase
implements ExprEvaluator,
ExprEvaluatorEnumeration {
    public static final ExprSubselectNode[] EMPTY_SUBSELECT_ARRAY = new ExprSubselectNode[0];
    private static final long serialVersionUID = -2469169635913155764L;
    private static final Log log = LogFactory.getLog(ExprSubselectNode.class);
    protected ExprNode[] selectClause;
    protected transient ExprEvaluator[] selectClauseEvaluator;
    protected String[] selectAsNames;
    protected transient ExprEvaluator filterExpr;
    protected transient EventType rawEventType;
    protected String statementName;
    private transient StreamTypeService filterSubqueryStreamTypes;
    private StatementSpecRaw statementSpecRaw;
    private transient StatementSpecCompiled statementSpecCompiled;
    private transient ExprSubselectStrategy strategy;
    private transient boolean aggregatedSubquery;
    protected int subselectNumber;
    private boolean filterStreamSubselect;

    public abstract Object evaluate(EventBean[] var1, boolean var2, Collection<EventBean> var3, ExprEvaluatorContext var4);

    public abstract Collection<EventBean> evaluateGetCollEvents(EventBean[] var1, boolean var2, Collection<EventBean> var3, ExprEvaluatorContext var4);

    public abstract Collection evaluateGetCollScalar(EventBean[] var1, boolean var2, Collection<EventBean> var3, ExprEvaluatorContext var4);

    public abstract boolean isAllowMultiColumnSelect();

    public abstract void validateSubquery(ExprValidationContext var1) throws ExprValidationException;

    public ExprSubselectNode(StatementSpecRaw statementSpec) {
        this.statementSpecRaw = statementSpec;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.statementName = validationContext.getStatementName();
        this.validateSubquery(validationContext);
    }

    public void setStatementSpecCompiled(StatementSpecCompiled statementSpecCompiled, int subselectNumber) {
        this.statementSpecCompiled = statementSpecCompiled;
        this.subselectNumber = subselectNumber;
    }

    public StatementSpecCompiled getStatementSpecCompiled() {
        return this.statementSpecCompiled;
    }

    public void setSelectClause(ExprNode[] selectClause) {
        this.selectClause = selectClause;
        this.selectClauseEvaluator = ExprNodeUtility.getEvaluators(selectClause);
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Collection<EventBean> matchingEvents = this.evaluateMatching(eventsPerStream, exprEvaluatorContext);
        return this.evaluate(eventsPerStream, isNewData, matchingEvents, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Collection<EventBean> matchingEvents = this.evaluateMatching(eventsPerStream, exprEvaluatorContext);
        return this.evaluateGetCollEvents(eventsPerStream, isNewData, matchingEvents, exprEvaluatorContext);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Collection<EventBean> matchingEvents = this.evaluateMatching(eventsPerStream, exprEvaluatorContext);
        return this.evaluateGetCollScalar(eventsPerStream, isNewData, matchingEvents, exprEvaluatorContext);
    }

    private Collection<EventBean> evaluateMatching(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        return this.strategy.evaluateMatching(eventsPerStream, exprEvaluatorContext);
    }

    public StatementSpecRaw getStatementSpecRaw() {
        return this.statementSpecRaw;
    }

    public void setSelectAsNames(String[] selectAsNames) {
        this.selectAsNames = selectAsNames;
    }

    public void setFilterExpr(ExprEvaluator filterExpr) {
        this.filterExpr = filterExpr;
    }

    @Override
    public String toExpressionString() {
        if (this.selectAsNames != null && this.selectAsNames[0] != null) {
            return this.selectAsNames[0];
        }
        if (this.selectClause == null) {
            return "*";
        }
        return this.selectClause[0].toExpressionString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return false;
    }

    public void setStrategy(ExprSubselectStrategy strategy) {
        this.strategy = strategy;
    }

    public void setRawEventType(EventType rawEventType) {
        this.rawEventType = rawEventType;
    }

    public ExprNode[] getSelectClause() {
        return this.selectClause;
    }

    public ExprEvaluator getFilterExpr() {
        return this.filterExpr;
    }

    public EventType getRawEventType() {
        return this.rawEventType;
    }

    public StreamTypeService getFilterSubqueryStreamTypes() {
        return this.filterSubqueryStreamTypes;
    }

    public void setFilterSubqueryStreamTypes(StreamTypeService filterSubqueryStreamTypes) {
        this.filterSubqueryStreamTypes = filterSubqueryStreamTypes;
    }

    public boolean isAggregatedSubquery() {
        return this.aggregatedSubquery;
    }

    public void setAggregatedSubquery(boolean aggregatedSubquery) {
        this.aggregatedSubquery = aggregatedSubquery;
    }

    public int getSubselectNumber() {
        return this.subselectNumber;
    }

    public void setFilterStreamSubselect(boolean filterStreamSubselect) {
        this.filterStreamSubselect = filterStreamSubselect;
    }

    public boolean isFilterStreamSubselect() {
        return this.filterStreamSubselect;
    }

    public static ExprSubselectNode[] toArray(List<ExprSubselectNode> subselectNodes) {
        if (subselectNodes.isEmpty()) {
            return EMPTY_SUBSELECT_ARRAY;
        }
        return subselectNodes.toArray(new ExprSubselectNode[subselectNodes.size()]);
    }
}

