/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprSubselectRowNode
extends ExprSubselectNode {
    private static final Log log = LogFactory.getLog(ExprSubselectRowNode.class);
    private static final long serialVersionUID = -7865711714805807559L;
    private transient SubselectMultirowType subselectMultirowType;

    public ExprSubselectRowNode(StatementSpecRaw statementSpec) {
        super(statementSpec);
    }

    @Override
    public Class getType() {
        if (this.selectClause == null) {
            return this.rawEventType.getUnderlyingType();
        }
        if (this.selectClause.length == 1) {
            return JavaClassHelper.getBoxedType(this.selectClause[0].getExprEvaluator().getType());
        }
        return null;
    }

    @Override
    public Map<String, Object> getEventType() throws ExprValidationException {
        if (this.selectClause == null || this.selectClause.length < 2) {
            return null;
        }
        return this.getRowType();
    }

    @Override
    public void validateSubquery(ExprValidationContext validationContext) throws ExprValidationException {
    }

    @Override
    public Collection<EventBean> evaluateGetCollEvents(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext context) {
        if (matchingEvents == null) {
            return null;
        }
        if (matchingEvents.size() == 0) {
            return Collections.emptyList();
        }
        if (this.filterExpr == null && this.selectClause == null) {
            return matchingEvents;
        }
        if (this.filterExpr != null) {
            EventBean[] events = new EventBean[eventsPerStream.length + 1];
            System.arraycopy(eventsPerStream, 0, events, 1, eventsPerStream.length);
            ArrayDeque<EventBean> filtered = new ArrayDeque<EventBean>();
            Iterator<EventBean> i$ = matchingEvents.iterator();
            while (i$.hasNext()) {
                EventBean subselectEvent;
                events[0] = subselectEvent = i$.next();
                Boolean pass = (Boolean)this.filterExpr.evaluate(events, true, context);
                if (pass == null || !pass.booleanValue()) continue;
                filtered.add(subselectEvent);
            }
            if (this.selectClause == null) {
                return filtered;
            }
        }
        return null;
    }

    @Override
    public Collection evaluateGetCollScalar(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext context) {
        if (matchingEvents == null) {
            return null;
        }
        if (matchingEvents.size() == 0) {
            return Collections.emptyList();
        }
        if (this.selectClauseEvaluator == null || this.selectClauseEvaluator.length < 1) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        EventBean[] events = new EventBean[eventsPerStream.length + 1];
        System.arraycopy(eventsPerStream, 0, events, 1, eventsPerStream.length);
        if (this.filterExpr != null) {
            Iterator<EventBean> i$ = matchingEvents.iterator();
            while (i$.hasNext()) {
                EventBean subselectEvent;
                events[0] = subselectEvent = i$.next();
                Boolean pass = (Boolean)this.filterExpr.evaluate(events, true, context);
                if (pass == null || !pass.booleanValue()) continue;
                result.add(this.selectClauseEvaluator[0].evaluate(events, isNewData, context));
            }
        } else {
            Iterator<EventBean> i$ = matchingEvents.iterator();
            while (i$.hasNext()) {
                EventBean subselectEvent;
                events[0] = subselectEvent = i$.next();
                result.add(this.selectClauseEvaluator[0].evaluate(events, isNewData, context));
            }
        }
        return result;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, String statementId) throws ExprValidationException {
        if (!this.isAggregatedSubquery() || this.selectClause == null) {
            return null;
        }
        Map<String, Object> rowType = this.getRowType();
        EventType resultEventType = eventAdapterService.createAnonymousMapType(statementId + "_subquery_" + this.getSubselectNumber(), rowType);
        this.subselectMultirowType = new SubselectMultirowType(resultEventType, eventAdapterService);
        return resultEventType;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Map<String, Object> row = this.evaluateRow(eventsPerStream, true, context);
        return this.subselectMultirowType.getEventAdapterService().adapterForTypedMap(row, this.subselectMultirowType.getEventType());
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService) throws ExprValidationException {
        if (this.selectClause == null) {
            return this.rawEventType;
        }
        return null;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        if (this.selectClause == null) {
            return null;
        }
        if (this.selectClauseEvaluator.length > 1) {
            return null;
        }
        return this.selectClauseEvaluator[0].getType();
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (matchingEvents == null) {
            return null;
        }
        if (matchingEvents.size() == 0) {
            return null;
        }
        if (this.filterExpr == null && matchingEvents.size() > 1) {
            log.warn(this.getMultirowMessage());
            return null;
        }
        EventBean subSelectResult = null;
        EventBean[] events = new EventBean[eventsPerStream.length + 1];
        System.arraycopy(eventsPerStream, 0, events, 1, eventsPerStream.length);
        if (this.filterExpr != null) {
            Iterator<EventBean> i$ = matchingEvents.iterator();
            while (i$.hasNext()) {
                EventBean subselectEvent;
                events[0] = subselectEvent = i$.next();
                Boolean pass = (Boolean)this.filterExpr.evaluate(events, true, exprEvaluatorContext);
                if (pass == null || !pass.booleanValue()) continue;
                if (subSelectResult != null) {
                    log.warn(this.getMultirowMessage());
                    return null;
                }
                subSelectResult = subselectEvent;
            }
            if (subSelectResult == null) {
                return null;
            }
        } else {
            subSelectResult = matchingEvents.iterator().next();
        }
        events[0] = subSelectResult;
        Object result = this.selectClause != null ? (this.selectClause.length == 1 ? this.selectClauseEvaluator[0].evaluate(events, true, exprEvaluatorContext) : this.evaluateRow(events, true, exprEvaluatorContext)) : events[0].getUnderlying();
        return result;
    }

    @Override
    public boolean isAllowMultiColumnSelect() {
        return true;
    }

    private Map<String, Object> evaluateRow(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.selectClauseEvaluator.length; ++i) {
            Object resultEntry = this.selectClauseEvaluator[i].evaluate(eventsPerStream, isNewData, context);
            map.put(this.selectAsNames[i], resultEntry);
        }
        return map;
    }

    private Map<String, Object> getRowType() throws ExprValidationException {
        HashSet<String> uniqueNames = new HashSet<String>();
        LinkedHashMap<String, Object> type = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.selectClause.length; ++i) {
            String assignedName = this.selectAsNames[i];
            if (assignedName == null) {
                assignedName = this.selectClause[i].toExpressionString();
            }
            if (!uniqueNames.add(assignedName)) {
                throw new ExprValidationException("Column " + i + " in subquery does not have a unique column name assigned");
            }
            type.put(assignedName, this.selectClause[i].getExprEvaluator().getType());
        }
        return type;
    }

    public Object getMultirowMessage() {
        return "Subselect of statement '" + this.statementName + "' returned more then one row in subselect " + this.subselectNumber + " '" + this.toExpressionString() + "', returning null result";
    }

    private static class SubselectMultirowType {
        private final EventType eventType;
        private final EventAdapterService eventAdapterService;

        private SubselectMultirowType(EventType eventType, EventAdapterService eventAdapterService) {
            this.eventType = eventType;
            this.eventAdapterService = eventAdapterService;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public EventAdapterService getEventAdapterService() {
            return this.eventAdapterService;
        }
    }
}

