/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.vaevent.VariantEvent;
import java.util.Map;

public class ExprTypeofNode
extends ExprNodeBase {
    private static final long serialVersionUID = -612634538694877204L;
    private transient ExprEvaluator evaluator;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 1) {
            throw new ExprValidationException("Typeof node must have 1 child expression node supplying the expression to test");
        }
        if (this.getChildNodes()[0] instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode stream = (ExprStreamUnderlyingNode)this.getChildNodes()[0];
            this.evaluator = new StreamEventTypeEval(stream.getStreamId());
            return;
        }
        if (this.getChildNodes()[0] instanceof ExprIdentNode) {
            ExprIdentNode ident = (ExprIdentNode)this.getChildNodes()[0];
            int streamNum = validationContext.getStreamTypeService().getStreamNumForStreamName(ident.getFullUnresolvedName());
            if (streamNum != -1) {
                this.evaluator = new StreamEventTypeEval(streamNum);
                return;
            }
            EventType eventType = validationContext.getStreamTypeService().getEventTypes()[ident.getStreamId()];
            if (eventType.getFragmentType(ident.getResolvedPropertyName()) != null) {
                this.evaluator = new FragmentTypeEval(ident.getStreamId(), eventType, ident.getResolvedPropertyName());
                return;
            }
        }
        this.evaluator = new InnerEvaluator(this.getChildNodes()[0].getExprEvaluator());
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    public Class getType() {
        return String.class;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("typeof(");
        buffer.append(this.getChildNodes()[0].toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprTypeofNode;
    }

    private static class InnerEvaluator
    implements ExprEvaluator {
        private final ExprEvaluator evaluator;

        public InnerEvaluator(ExprEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public Map<String, Object> getEventType() throws ExprValidationException {
            return null;
        }

        @Override
        public Class getType() {
            return String.class;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Object result = this.evaluator.evaluate(eventsPerStream, isNewData, context);
            if (result == null) {
                return null;
            }
            return result.getClass().getSimpleName();
        }
    }

    public static class FragmentTypeEval
    implements ExprEvaluator {
        private final int streamId;
        private final EventPropertyGetter getter;
        private final String fragmentType;

        public FragmentTypeEval(int streamId, EventType eventType, String resolvedPropertyName) {
            this.streamId = streamId;
            this.getter = eventType.getGetter(resolvedPropertyName);
            this.fragmentType = eventType.getFragmentType(resolvedPropertyName).getFragmentType().getName();
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            EventBean theEvent = eventsPerStream[this.streamId];
            if (theEvent == null) {
                return null;
            }
            Object fragment = this.getter.getFragment(theEvent);
            if (fragment == null) {
                return null;
            }
            if (fragment instanceof EventBean) {
                return ((EventBean)fragment).getEventType().getName();
            }
            if (fragment.getClass().isArray()) {
                return this.fragmentType + "[]";
            }
            return null;
        }

        @Override
        public Class getType() {
            return String.class;
        }

        @Override
        public Map<String, Object> getEventType() throws ExprValidationException {
            return null;
        }
    }

    public static class StreamEventTypeEval
    implements ExprEvaluator {
        private final int streamNum;

        public StreamEventTypeEval(int streamNum) {
            this.streamNum = streamNum;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            EventBean theEvent = eventsPerStream[this.streamNum];
            if (theEvent == null) {
                return null;
            }
            if (theEvent instanceof VariantEvent) {
                return ((VariantEvent)((Object)theEvent)).getUnderlyingEventBean().getEventType().getName();
            }
            return theEvent.getEventType().getName();
        }

        @Override
        public Class getType() {
            return String.class;
        }

        @Override
        public Map<String, Object> getEventType() throws ExprValidationException {
            return null;
        }
    }
}

