/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.DuplicatePropertyException;
import com.espertech.esper.epl.core.PropertyNotFoundException;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprVariableNode;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventTypeSPI;
import java.util.Map;

public class ExprVariableNodeImpl
extends ExprNodeBase
implements ExprEvaluator,
ExprVariableNode {
    private static final long serialVersionUID = 0L;
    private final String variableName;
    private final String optSubPropName;
    private Class variableType;
    private boolean isPrimitive;
    private transient VariableReader reader;
    private transient EventPropertyGetter eventTypeGetter;

    public ExprVariableNodeImpl(String variableName, VariableService variableService) {
        if (variableName == null) {
            throw new IllegalArgumentException("Variables name is null");
        }
        int indexOfDot = variableName.indexOf(46);
        if (indexOfDot != -1) {
            this.optSubPropName = variableName.substring(indexOfDot + 1, variableName.length());
            this.variableName = variableName.substring(0, indexOfDot);
        } else {
            this.variableName = variableName;
            this.optSubPropName = null;
        }
        if (variableService != null) {
            this.reader = variableService.getReader(variableName);
        }
    }

    @Override
    public Object getValue() {
        if (this.reader == null) {
            throw new EPException("Variable expression node has not been initialized");
        }
        return this.reader.getValue();
    }

    @Override
    public boolean isConstantValue() {
        return this.reader != null && this.reader.isConstant();
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.reader = validationContext.getVariableService().getReader(this.variableName);
        if (this.reader == null) {
            throw new ExprValidationException("A variable by name '" + this.variableName + " has not been declared");
        }
        boolean hasPropertyAgnosticType = false;
        EventType[] types = validationContext.getStreamTypeService().getEventTypes();
        for (int i = 0; i < validationContext.getStreamTypeService().getEventTypes().length; ++i) {
            if (!(types[i] instanceof EventTypeSPI)) continue;
            hasPropertyAgnosticType |= ((EventTypeSPI)types[i]).getMetadata().isPropertyAgnostic();
        }
        if (!hasPropertyAgnosticType) {
            try {
                validationContext.getStreamTypeService().resolveByPropertyName(this.variableName, false);
                throw new ExprValidationException("The variable by name '" + this.variableName + "' is ambigous to a property of the same name");
            }
            catch (DuplicatePropertyException e) {
                throw new ExprValidationException("The variable by name '" + this.variableName + "' is ambigous to a property of the same name");
            }
            catch (PropertyNotFoundException e) {
                // empty catch block
            }
        }
        this.variableType = this.reader.getType();
        boolean bl = this.isPrimitive = this.reader.getEventType() == null;
        if (this.optSubPropName != null) {
            if (this.reader.getEventType() == null) {
                throw new ExprValidationException("Property '" + this.optSubPropName + "' is not valid for variable '" + this.variableName + "'");
            }
            this.eventTypeGetter = this.reader.getEventType().getGetter(this.optSubPropName);
            if (this.eventTypeGetter == null) {
                throw new ExprValidationException("Property '" + this.optSubPropName + "' is not valid for variable '" + this.variableName + "'");
            }
            this.variableType = this.reader.getEventType().getPropertyType(this.optSubPropName);
        }
    }

    @Override
    public Class getType() {
        if (this.variableType == null) {
            throw new IllegalStateException("Variables node has not been validated");
        }
        return this.variableType;
    }

    @Override
    public boolean isConstantResult() {
        return this.reader.isConstant();
    }

    public String toString() {
        return "variableName=" + this.variableName;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object value = this.reader.getValue();
        if (this.isPrimitive) {
            return value;
        }
        if (value == null) {
            return null;
        }
        EventBean theEvent = (EventBean)value;
        if (this.optSubPropName == null) {
            return theEvent.getUnderlying();
        }
        return this.eventTypeGetter.get(theEvent);
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.variableName);
        if (this.optSubPropName != null) {
            buffer.append(".");
            buffer.append(this.optSubPropName);
        }
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprVariableNodeImpl)) {
            return false;
        }
        ExprVariableNodeImpl that = (ExprVariableNodeImpl)node;
        if (this.optSubPropName != null ? !this.optSubPropName.equals(that.optSubPropName) : that.optSubPropName != null) {
            return false;
        }
        return that.variableName.equals(this.variableName);
    }

    @Override
    public String getVariableNameWithSubProp() {
        if (this.optSubPropName == null) {
            return this.variableName;
        }
        return this.variableName + "." + this.optSubPropName;
    }
}

