/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.SubselectEvalStrategy;
import com.espertech.esper.epl.expression.SubselectEvalStrategyEqualsAll;
import com.espertech.esper.epl.expression.SubselectEvalStrategyEqualsAny;
import com.espertech.esper.epl.expression.SubselectEvalStrategyEqualsIn;
import com.espertech.esper.epl.expression.SubselectEvalStrategyRelOpAll;
import com.espertech.esper.epl.expression.SubselectEvalStrategyRelOpAny;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Collection;
import java.util.Map;

public class SubselectEvalStrategyFactory {
    public static SubselectEvalStrategy createStrategy(ExprSubselectNode subselectExpression, boolean isNot, boolean isAll, boolean isAny, RelationalOpEnum relationalOp) throws ExprValidationException {
        ExprEvaluator filter;
        Class coercionType;
        if (subselectExpression.getChildNodes().length != 1) {
            throw new ExprValidationException("The Subselect-IN requires 1 child expression");
        }
        ExprNode valueExpr = subselectExpression.getChildNodes()[0];
        Class typeOne = JavaClassHelper.getBoxedType(subselectExpression.getChildNodes()[0].getExprEvaluator().getType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        Class typeTwo = subselectExpression.getSelectClause() != null ? subselectExpression.getSelectClause()[0].getExprEvaluator().getType() : subselectExpression.getRawEventType().getUnderlyingType();
        if (relationalOp != null) {
            if (typeOne != String.class || typeTwo != String.class) {
                if (!JavaClassHelper.isNumeric(typeOne)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
                }
                if (!JavaClassHelper.isNumeric(typeTwo)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
                }
            }
            Class compareType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
            RelationalOpEnum.Computer computer = relationalOp.getComputer(compareType, typeOne, typeTwo);
            ExprEvaluator selectClause = subselectExpression.getSelectClause() == null ? null : subselectExpression.getSelectClause()[0].getExprEvaluator();
            ExprEvaluator filterExpr = subselectExpression.getFilterExpr();
            if (isAny) {
                return new SubselectEvalStrategyRelOpAny(computer, valueExpr.getExprEvaluator(), selectClause, filterExpr);
            }
            return new SubselectEvalStrategyRelOpAll(computer, valueExpr.getExprEvaluator(), selectClause, filterExpr);
        }
        try {
            coercionType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to '" + typeOne.getSimpleName() + "' is not allowed");
        }
        boolean mustCoerce = false;
        if ((coercionType != JavaClassHelper.getBoxedType(typeOne) || coercionType != JavaClassHelper.getBoxedType(typeTwo)) && JavaClassHelper.isNumeric(coercionType)) {
            mustCoerce = true;
        }
        ExprEvaluator value = valueExpr.getExprEvaluator();
        ExprEvaluator select = subselectExpression.getSelectClause() == null ? null : subselectExpression.getSelectClause()[0].getExprEvaluator();
        ExprEvaluator exprEvaluator = filter = subselectExpression.getFilterExpr() == null ? null : subselectExpression.getFilterExpr();
        if (isAll) {
            return new SubselectEvalStrategyEqualsAll(isNot, mustCoerce, coercionType, value, select, filter);
        }
        if (isAny) {
            return new SubselectEvalStrategyEqualsAny(isNot, mustCoerce, coercionType, value, select, filter);
        }
        return new SubselectEvalStrategyEqualsIn(isNot, mustCoerce, coercionType, value, select, filter);
    }
}

