/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQuery;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQueryFactory;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HistoricalIndexLookupStrategyComposite
implements HistoricalIndexLookupStrategy {
    private final CompositeIndexQuery chain;

    public HistoricalIndexLookupStrategyComposite(int lookupStream, List<QueryGraphValueEntryHashKeyed> hashKeys, Class[] keyCoercionTypes, List<QueryGraphValueEntryRange> rangeKeyPairs, Class[] rangeCoercionTypes) {
        this.chain = CompositeIndexQueryFactory.makeJoinSingleLookupStream(false, lookupStream, hashKeys, keyCoercionTypes, rangeKeyPairs, rangeCoercionTypes);
    }

    @Override
    public Iterator<EventBean> lookup(EventBean lookupEvent, EventTable indexTable, ExprEvaluatorContext context) {
        if (indexTable instanceof PropertyCompositeEventTable) {
            PropertyCompositeEventTable table = (PropertyCompositeEventTable)indexTable;
            Map<Object, Object> index = table.getIndex();
            Set<EventBean> events = this.chain.get(lookupEvent, index, context);
            if (events != null) {
                return events.iterator();
            }
            return null;
        }
        return indexTable.iterator();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " chain " + this.chain.getClass().getSimpleName();
    }
}

