/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.FlushedEventBuffer;
import com.espertech.esper.core.service.EPStatementDispatch;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.JoinExecutionStrategy;
import com.espertech.esper.view.internal.BufferObserver;
import java.util.HashMap;
import java.util.Map;

public class JoinExecStrategyDispatchable
implements EPStatementDispatch,
BufferObserver {
    private final JoinExecutionStrategy joinExecutionStrategy;
    private final Map<Integer, FlushedEventBuffer> oldStreamBuffer;
    private final Map<Integer, FlushedEventBuffer> newStreamBuffer;
    private final int numStreams;
    private boolean hasNewData;

    public JoinExecStrategyDispatchable(JoinExecutionStrategy joinExecutionStrategy, int numStreams) {
        this.joinExecutionStrategy = joinExecutionStrategy;
        this.numStreams = numStreams;
        this.oldStreamBuffer = new HashMap<Integer, FlushedEventBuffer>();
        this.newStreamBuffer = new HashMap<Integer, FlushedEventBuffer>();
    }

    @Override
    public void execute(ExprEvaluatorContext exprEvaluatorContext) {
        if (!this.hasNewData) {
            return;
        }
        this.hasNewData = false;
        EventBean[][] oldDataPerStream = new EventBean[this.numStreams][];
        EventBean[][] newDataPerStream = new EventBean[this.numStreams][];
        for (int i = 0; i < this.numStreams; ++i) {
            oldDataPerStream[i] = JoinExecStrategyDispatchable.getBufferData(this.oldStreamBuffer.get(i));
            newDataPerStream[i] = JoinExecStrategyDispatchable.getBufferData(this.newStreamBuffer.get(i));
        }
        this.joinExecutionStrategy.join(newDataPerStream, oldDataPerStream, exprEvaluatorContext);
    }

    private static EventBean[] getBufferData(FlushedEventBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return buffer.getAndFlush();
    }

    @Override
    public void newData(int streamId, FlushedEventBuffer newEventBuffer, FlushedEventBuffer oldEventBuffer) {
        this.hasNewData = true;
        this.newStreamBuffer.put(streamId, newEventBuffer);
        this.oldStreamBuffer.put(streamId, oldEventBuffer);
    }
}

