/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.JoinExecutionStrategy;
import com.espertech.esper.epl.join.base.JoinSetComposer;
import com.espertech.esper.epl.join.base.JoinSetProcessor;
import java.util.Set;

public class JoinExecutionStrategyImpl
implements JoinExecutionStrategy {
    private final JoinSetComposer composer;
    private final JoinSetProcessor filter;
    private final JoinSetProcessor indicator;
    private final ExprEvaluatorContext staticExprEvaluatorContext;

    public JoinExecutionStrategyImpl(JoinSetComposer composer, JoinSetProcessor filter, JoinSetProcessor indicator, ExprEvaluatorContext staticExprEvaluatorContext) {
        this.composer = composer;
        this.filter = filter;
        this.indicator = indicator;
        this.staticExprEvaluatorContext = staticExprEvaluatorContext;
    }

    @Override
    public void join(EventBean[][] newDataPerStream, EventBean[][] oldDataPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        UniformPair<Set<MultiKey<EventBean>>> joinSet = this.composer.join(newDataPerStream, oldDataPerStream, exprEvaluatorContext);
        this.filter.process(joinSet.getFirst(), joinSet.getSecond(), exprEvaluatorContext);
        if (!joinSet.getFirst().isEmpty() || !joinSet.getSecond().isEmpty()) {
            this.indicator.process(joinSet.getFirst(), joinSet.getSecond(), exprEvaluatorContext);
        }
    }

    @Override
    public Set<MultiKey<EventBean>> staticJoin() {
        Set<MultiKey<EventBean>> joinSet = this.composer.staticJoin();
        this.filter.process(joinSet, null, this.staticExprEvaluatorContext);
        return joinSet;
    }
}

