/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.JoinSetComposerImpl;
import com.espertech.esper.epl.join.base.QueryStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import java.util.Map;
import java.util.Set;

public class JoinSetComposerFAFImpl
extends JoinSetComposerImpl {
    private final boolean isOuterJoins;

    public JoinSetComposerFAFImpl(Map<String, EventTable>[] repositories, QueryStrategy[] queryStrategies, boolean isPureSelfJoin, ExprEvaluatorContext exprEvaluatorContext, boolean joinRemoveStream, boolean outerJoins) {
        super(repositories, queryStrategies, isPureSelfJoin, exprEvaluatorContext, joinRemoveStream);
        this.isOuterJoins = outerJoins;
    }

    @Override
    public void init(EventBean[][] eventsPerStream) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public UniformPair<Set<MultiKey<EventBean>>> join(EventBean[][] newDataPerStream, EventBean[][] oldDataPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        this.newResults.clear();
        for (int stream = 0; stream < newDataPerStream.length; ++stream) {
            for (int j = 0; j < this.repositories[stream].length; ++j) {
                this.repositories[stream][j].addRemove(newDataPerStream[stream], oldDataPerStream[stream]);
            }
        }
        if (this.isOuterJoins) {
            for (int i = 0; i < newDataPerStream.length; ++i) {
                if (newDataPerStream[i] == null) continue;
                this.queryStrategies[i].lookup(newDataPerStream[i], this.newResults, exprEvaluatorContext);
            }
        } else {
            int minStream = -1;
            int minStreamCount = -1;
            for (int i = 0; i < newDataPerStream.length; ++i) {
                if (newDataPerStream[i] == null) continue;
                if (newDataPerStream[i].length == 0) {
                    minStream = -1;
                    break;
                }
                if (newDataPerStream[i].length <= minStreamCount) continue;
                minStream = i;
                minStreamCount = newDataPerStream[i].length;
            }
            if (minStream != -1) {
                this.queryStrategies[minStream].lookup(newDataPerStream[minStream], this.newResults, exprEvaluatorContext);
            }
        }
        return new UniformPair<Set<MultiKey<EventBean>>>(this.newResults, this.oldResults);
    }

    @Override
    public Set<MultiKey<EventBean>> staticJoin() {
        return null;
    }
}

