/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.epl.expression.ExprAndNodeImpl;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.base.ExecNodeQueryStrategy;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.base.JoinSetComposer;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerFAFImpl;
import com.espertech.esper.epl.join.base.JoinSetComposerHistoricalImpl;
import com.espertech.esper.epl.join.base.JoinSetComposerImpl;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeFactory;
import com.espertech.esper.epl.join.base.JoinSetComposerStreamToWinImpl;
import com.espertech.esper.epl.join.base.QueryStrategy;
import com.espertech.esper.epl.join.exec.base.ExecNode;
import com.espertech.esper.epl.join.plan.QueryPlan;
import com.espertech.esper.epl.join.plan.QueryPlanIndex;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableUtil;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JoinSetComposerPrototypeImpl
implements JoinSetComposerPrototype {
    private static final Log log = LogFactory.getLog(JoinSetComposerPrototypeFactory.class);
    private final String statementName;
    private final String statementId;
    private final OuterJoinDesc[] outerJoinDescList;
    private final ExprNode optionalFilterNode;
    private final EventType[] streamTypes;
    private final String[] streamNames;
    private final StreamJoinAnalysisResult streamJoinAnalysisResult;
    private final Annotation[] annotations;
    private final HistoricalViewableDesc historicalViewableDesc;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final QueryPlanIndex[] indexSpecs;
    private final QueryPlan queryPlan;
    private final HistoricalStreamIndexList[] historicalStreamIndexLists;
    private final boolean joinRemoveStream;
    private final boolean isOuterJoins;

    public JoinSetComposerPrototypeImpl(String statementName, String statementId, OuterJoinDesc[] outerJoinDescList, ExprNode optionalFilterNode, EventType[] streamTypes, String[] streamNames, StreamJoinAnalysisResult streamJoinAnalysisResult, Annotation[] annotations, HistoricalViewableDesc historicalViewableDesc, ExprEvaluatorContext exprEvaluatorContext, QueryPlanIndex[] indexSpecs, QueryPlan queryPlan, HistoricalStreamIndexList[] historicalStreamIndexLists, boolean joinRemoveStream, boolean isOuterJoins) {
        this.statementName = statementName;
        this.statementId = statementId;
        this.outerJoinDescList = outerJoinDescList;
        this.optionalFilterNode = optionalFilterNode;
        this.streamTypes = streamTypes;
        this.streamNames = streamNames;
        this.streamJoinAnalysisResult = streamJoinAnalysisResult;
        this.annotations = annotations;
        this.historicalViewableDesc = historicalViewableDesc;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.indexSpecs = indexSpecs;
        this.queryPlan = queryPlan;
        this.historicalStreamIndexLists = historicalStreamIndexLists;
        this.joinRemoveStream = joinRemoveStream;
        this.isOuterJoins = isOuterJoins;
    }

    @Override
    public JoinSetComposerDesc create(Viewable[] streamViews, boolean isFireAndForget) {
        JoinSetComposerDesc joinSetComposerDesc;
        HashMap[] indexesPerStream = new HashMap[this.indexSpecs.length];
        for (int streamNo = 0; streamNo < this.indexSpecs.length; ++streamNo) {
            if (this.indexSpecs[streamNo] == null) continue;
            Map<String, QueryPlanIndexItem> items = this.indexSpecs[streamNo].getItems();
            indexesPerStream[streamNo] = new LinkedHashMap();
            for (Map.Entry<String, QueryPlanIndexItem> entry : items.entrySet()) {
                EventTable index = this.streamJoinAnalysisResult.getViewExternal()[streamNo] != null ? this.streamJoinAnalysisResult.getViewExternal()[streamNo].getJoinIndexTable(items.get(entry.getKey())) : EventTableUtil.buildIndex(streamNo, items.get(entry.getKey()), this.streamTypes[streamNo], false, entry.getValue().isUnique(), null);
                indexesPerStream[streamNo].put(entry.getKey(), index);
            }
        }
        QueryPlanNode[] queryExecSpecs = this.queryPlan.getExecNodeSpecs();
        QueryStrategy[] queryStrategies = new QueryStrategy[queryExecSpecs.length];
        for (int i = 0; i < queryExecSpecs.length; ++i) {
            QueryPlanNode planNode = queryExecSpecs[i];
            if (planNode == null) {
                log.debug((Object)(".makeComposer No execution node for stream " + i + " '" + this.streamNames[i] + "'"));
                continue;
            }
            ExecNode executionNode = planNode.makeExec(this.statementName, this.statementId, this.annotations, indexesPerStream, this.streamTypes, streamViews, this.historicalStreamIndexLists, this.streamJoinAnalysisResult.getViewExternal());
            if (log.isDebugEnabled()) {
                log.debug((Object)(".makeComposer Execution nodes for stream " + i + " '" + this.streamNames[i] + "' : \n" + ExecNode.print(executionNode)));
            }
            queryStrategies[i] = new ExecNodeQueryStrategy(i, this.streamTypes.length, executionNode);
        }
        if (!(this.streamJoinAnalysisResult.isUnidirectional() || this.streamJoinAnalysisResult.isPureSelfJoin() && this.outerJoinDescList.length <= 0)) {
            JoinSetComposer composer = this.historicalViewableDesc.isHasHistorical() ? new JoinSetComposerHistoricalImpl(indexesPerStream, queryStrategies, streamViews, this.exprEvaluatorContext) : (isFireAndForget ? new JoinSetComposerFAFImpl(indexesPerStream, queryStrategies, this.streamJoinAnalysisResult.isPureSelfJoin(), this.exprEvaluatorContext, this.joinRemoveStream, this.isOuterJoins) : new JoinSetComposerImpl(indexesPerStream, queryStrategies, this.streamJoinAnalysisResult.isPureSelfJoin(), this.exprEvaluatorContext, this.joinRemoveStream));
            ExprNode filterExpression = this.getFilterExpressionInclOnClause(this.optionalFilterNode, this.outerJoinDescList);
            ExprEvaluator postJoinEval = filterExpression == null ? null : filterExpression.getExprEvaluator();
            joinSetComposerDesc = new JoinSetComposerDesc(composer, postJoinEval);
        } else {
            QueryStrategy driver;
            int unidirectionalStream;
            if (this.streamJoinAnalysisResult.getUnidirectionalStreamNumber() != -1) {
                unidirectionalStream = this.streamJoinAnalysisResult.getUnidirectionalStreamNumber();
                driver = queryStrategies[unidirectionalStream];
            } else {
                unidirectionalStream = 0;
                driver = queryStrategies[0];
            }
            JoinSetComposerStreamToWinImpl composer = new JoinSetComposerStreamToWinImpl(indexesPerStream, this.streamJoinAnalysisResult.isPureSelfJoin(), unidirectionalStream, driver, this.streamJoinAnalysisResult.getUnidirectionalNonDriving());
            ExprEvaluator postJoinEval = this.optionalFilterNode == null ? null : this.optionalFilterNode.getExprEvaluator();
            joinSetComposerDesc = new JoinSetComposerDesc(composer, postJoinEval);
        }
        EventBean[][] eventsPerStream = new EventBean[this.streamNames.length][];
        ArrayList<EventBean> events = new ArrayList<EventBean>();
        for (int i = 0; i < eventsPerStream.length; ++i) {
            if (this.streamJoinAnalysisResult.getNamedWindow()[i]) continue;
            Iterator<EventBean> it = null;
            if (!(streamViews[i] instanceof HistoricalEventViewable)) {
                try {
                    it = streamViews[i].iterator();
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
            }
            if (it != null) {
                while (it.hasNext()) {
                    events.add(it.next());
                }
                eventsPerStream[i] = events.toArray(new EventBean[events.size()]);
                events.clear();
                continue;
            }
            eventsPerStream[i] = new EventBean[0];
        }
        joinSetComposerDesc.getJoinSetComposer().init(eventsPerStream);
        return joinSetComposerDesc;
    }

    private ExprNode getFilterExpressionInclOnClause(ExprNode optionalFilterNode, OuterJoinDesc[] outerJoinDescList) {
        if (optionalFilterNode == null) {
            return null;
        }
        if (outerJoinDescList.length == 0) {
            return optionalFilterNode;
        }
        if (!OuterJoinDesc.consistsOfAllInnerJoins(outerJoinDescList)) {
            return optionalFilterNode;
        }
        ExprAndNodeImpl andNode = new ExprAndNodeImpl();
        andNode.addChildNode(optionalFilterNode);
        for (OuterJoinDesc outerJoinDesc : outerJoinDescList) {
            andNode.addChildNode(outerJoinDesc.makeExprNode(null));
        }
        try {
            andNode.validate(null);
        }
        catch (ExprValidationException ex) {
            throw new RuntimeException("Unexpected exception validating expression: " + ex.getMessage(), ex);
        }
        return andNode;
    }
}

