/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.event.EventBeanUtility;
import java.util.Set;

public class IndexedTableLookupStrategySingle
implements JoinExecTableLookupStrategy {
    private final EventType eventType;
    private final String property;
    private final PropertyIndexedEventTableSingle index;
    private final EventPropertyGetter propertyGetter;

    public IndexedTableLookupStrategySingle(EventType eventType, String property, PropertyIndexedEventTableSingle index) {
        this.eventType = eventType;
        this.property = property;
        if (index == null) {
            throw new IllegalArgumentException("Unexpected null index received");
        }
        this.index = index;
        this.propertyGetter = EventBeanUtility.getAssertPropertyGetter(eventType, property);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public PropertyIndexedEventTableSingle getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        Object key = this.getKey(theEvent);
        return this.index.lookup(key);
    }

    private Object getKey(EventBean theEvent) {
        return this.propertyGetter.get(theEvent);
    }

    public String toString() {
        return "IndexedTableLookupStrategy indexProp=" + this.property + " index=(" + this.index + ')';
    }
}

