/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.rep.Repository;
import com.espertech.esper.util.IndentWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class LookupInstructionExec {
    private final int fromStream;
    private final String fromStreamName;
    private final JoinExecTableLookupStrategy[] lookupStrategies;
    private final int numSubStreams;
    private final Set<EventBean>[] resultPerStream;
    private final int[] requiredSubStreams;
    private final int[] optionalSubStreams;
    private final boolean hasRequiredSubStreams;

    public LookupInstructionExec(int fromStream, String fromStreamName, int[] toStreams, JoinExecTableLookupStrategy[] lookupStrategies, boolean[] requiredPerStream) {
        if (toStreams.length != lookupStrategies.length) {
            throw new IllegalArgumentException("Invalid number of strategies for each stream");
        }
        if (requiredPerStream.length < lookupStrategies.length) {
            throw new IllegalArgumentException("Invalid required per stream array");
        }
        if (fromStream < 0 || fromStream >= requiredPerStream.length) {
            throw new IllegalArgumentException("Invalid from stream");
        }
        this.fromStream = fromStream;
        this.fromStreamName = fromStreamName;
        this.numSubStreams = toStreams.length;
        this.lookupStrategies = lookupStrategies;
        this.resultPerStream = new Set[this.numSubStreams];
        LinkedList<Integer> required = new LinkedList<Integer>();
        LinkedList<Integer> optional = new LinkedList<Integer>();
        for (int stream : toStreams) {
            if (requiredPerStream[stream]) {
                required.add(stream);
                continue;
            }
            optional.add(stream);
        }
        this.requiredSubStreams = LookupInstructionExec.toArray(required);
        this.optionalSubStreams = LookupInstructionExec.toArray(optional);
        this.hasRequiredSubStreams = this.requiredSubStreams.length > 0;
    }

    public int getFromStream() {
        return this.fromStream;
    }

    public boolean hasRequiredStream() {
        return this.hasRequiredSubStreams;
    }

    public boolean process(Repository repository, ExprEvaluatorContext exprEvaluatorContext) {
        boolean hasOneResultRow = false;
        Iterator<Cursor> it = repository.getCursors(this.fromStream);
        while (it.hasNext()) {
            int i;
            Set<EventBean> lookupResult;
            int streamCount;
            Cursor cursor = it.next();
            EventBean lookupEvent = cursor.getTheEvent();
            for (streamCount = 0; streamCount < this.requiredSubStreams.length && (lookupResult = this.lookupStrategies[streamCount].lookup(lookupEvent, cursor, exprEvaluatorContext)) != null && !lookupResult.isEmpty(); ++streamCount) {
                this.resultPerStream[streamCount] = lookupResult;
            }
            if (streamCount < this.requiredSubStreams.length) continue;
            for (i = 0; i < this.requiredSubStreams.length; ++i) {
                hasOneResultRow = true;
                repository.addResult(cursor, this.resultPerStream[i], this.requiredSubStreams[i]);
            }
            for (i = 0; i < this.optionalSubStreams.length; ++i) {
                Set<EventBean> lookupResult2 = this.lookupStrategies[streamCount].lookup(lookupEvent, cursor, exprEvaluatorContext);
                if (lookupResult2 != null) {
                    hasOneResultRow = true;
                    repository.addResult(cursor, lookupResult2, this.optionalSubStreams[i]);
                }
                ++streamCount;
            }
        }
        return hasOneResultRow;
    }

    private static int[] toArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        int count = 0;
        for (int value : list) {
            arr[count++] = value;
        }
        return arr;
    }

    public void print(IndentWriter writer) {
        writer.println("LookupInstructionExec fromStream=" + this.fromStream + " fromStreamName=" + this.fromStreamName + " numSubStreams=" + this.numSubStreams + " requiredSubStreams=" + Arrays.toString(this.requiredSubStreams) + " optionalSubStreams=" + Arrays.toString(this.optionalSubStreams));
        writer.incrIndent();
        for (int i = 0; i < this.lookupStrategies.length; ++i) {
            writer.println("lookupStrategies[" + i + "] : " + this.lookupStrategies[i].toString());
        }
        writer.decrIndent();
    }
}

