/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.composite;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQuery;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.event.EventBeanUtility;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompositeIndexQueryKeyed
implements CompositeIndexQuery {
    private final ExprEvaluator[] evaluators;
    private final Class[] keyCoercionTypes;
    private final int lookupStream;
    private final EventBean[] events;
    private final boolean isNWOnTrigger;
    private CompositeIndexQuery next;

    public CompositeIndexQueryKeyed(boolean isNWOnTrigger, int lookupStream, int numStreams, List<QueryGraphValueEntryHashKeyed> hashKeys, Class[] keyCoercionTypes) {
        this.keyCoercionTypes = keyCoercionTypes;
        this.evaluators = new ExprEvaluator[hashKeys.size()];
        this.isNWOnTrigger = isNWOnTrigger;
        this.lookupStream = lookupStream;
        for (int i = 0; i < this.evaluators.length; ++i) {
            this.evaluators[i] = hashKeys.get(i).getKeyExpr().getExprEvaluator();
        }
        this.events = lookupStream != -1 ? new EventBean[lookupStream + 1] : new EventBean[numStreams + 1];
    }

    @Override
    public void setNext(CompositeIndexQuery next) {
        this.next = next;
    }

    @Override
    public Set<EventBean> get(EventBean theEvent, Map parent, ExprEvaluatorContext context) {
        this.events[this.lookupStream] = theEvent;
        MultiKeyUntyped mk = EventBeanUtility.getMultiKey(this.events, this.evaluators, context, this.keyCoercionTypes);
        Map innerIndex = (Map)parent.get(mk);
        if (innerIndex == null) {
            return null;
        }
        return this.next.get(theEvent, innerIndex, context);
    }

    @Override
    public Collection<EventBean> get(EventBean[] eventsPerStream, Map parent, ExprEvaluatorContext context) {
        EventBean[] eventsToUse;
        if (this.isNWOnTrigger) {
            eventsToUse = eventsPerStream;
        } else {
            System.arraycopy(eventsPerStream, 0, this.events, 1, eventsPerStream.length);
            eventsToUse = this.events;
        }
        MultiKeyUntyped mk = EventBeanUtility.getMultiKey(eventsToUse, this.evaluators, context, this.keyCoercionTypes);
        Map innerIndex = (Map)parent.get(mk);
        if (innerIndex == null) {
            return null;
        }
        return this.next.get(eventsPerStream, innerIndex, context);
    }

    @Override
    public void add(EventBean theEvent, Map value, Set<EventBean> result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(EventBean[] eventsPerStream, Map value, Collection<EventBean> result) {
        throw new UnsupportedOperationException();
    }
}

