/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.exec.base.IndexedTableLookupStrategySingle;
import com.espertech.esper.epl.join.exec.base.IndexedTableLookupStrategySingleExpr;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedExpr;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedProp;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.TableLookupKeyDesc;
import com.espertech.esper.epl.join.plan.TableLookupPlan;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import java.util.Collections;

public class IndexedTableLookupPlanSingle
extends TableLookupPlan {
    private QueryGraphValueEntryHashKeyed hashKey;

    public IndexedTableLookupPlanSingle(int lookupStream, int indexedStream, String indexNum, QueryGraphValueEntryHashKeyed hashKey) {
        super(lookupStream, indexedStream, indexNum);
        this.hashKey = hashKey;
    }

    @Override
    public TableLookupKeyDesc getKeyDescriptor() {
        return new TableLookupKeyDesc(Collections.singletonList(this.hashKey), Collections.<QueryGraphValueEntryRange>emptyList());
    }

    @Override
    public JoinExecTableLookupStrategy makeStrategyInternal(EventTable eventTable, EventType[] eventTypes) {
        PropertyIndexedEventTableSingle index = (PropertyIndexedEventTableSingle)eventTable;
        if (this.hashKey instanceof QueryGraphValueEntryHashKeyedExpr) {
            QueryGraphValueEntryHashKeyedExpr expr = (QueryGraphValueEntryHashKeyedExpr)this.hashKey;
            return new IndexedTableLookupStrategySingleExpr(expr.getKeyExpr(), super.getLookupStream(), index);
        }
        if (this.hashKey instanceof QueryGraphValueEntryHashKeyedProp) {
            QueryGraphValueEntryHashKeyedProp prop = (QueryGraphValueEntryHashKeyedProp)this.hashKey;
            return new IndexedTableLookupStrategySingle(eventTypes[this.getLookupStream()], prop.getKeyProperty(), index);
        }
        throw new IllegalArgumentException("Invalid hashkey instance " + this.hashKey);
    }

    public QueryGraphValueEntryHashKeyed getHashKey() {
        return this.hashKey;
    }

    @Override
    public String toString() {
        return "IndexedTableLookupPlan " + super.toString() + " keyProperty=" + this.getKeyDescriptor();
    }
}

