/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.join.plan.CoercionDesc;
import com.espertech.esper.epl.join.plan.CoercionUtil;
import com.espertech.esper.epl.join.plan.CompositeTableLookupPlan;
import com.espertech.esper.epl.join.plan.FullTableScanLookupPlan;
import com.espertech.esper.epl.join.plan.IndexedTableLookupPlanMulti;
import com.espertech.esper.epl.join.plan.IndexedTableLookupPlanSingle;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryGraphValue;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairHashKeyIndex;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairRangeIndex;
import com.espertech.esper.epl.join.plan.QueryPlan;
import com.espertech.esper.epl.join.plan.QueryPlanIndex;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.plan.QueryPlanIndexUniqueHelper;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.plan.SortedTableLookupPlan;
import com.espertech.esper.epl.join.plan.TableLookupNode;
import com.espertech.esper.epl.join.plan.TableLookupPlan;
import com.espertech.esper.epl.join.plan.TableOuterLookupNode;
import com.espertech.esper.type.OuterJoinType;
import java.util.Collections;
import java.util.List;

public class TwoStreamQueryPlanBuilder {
    public static QueryPlan build(EventType[] typesPerStream, QueryGraph queryGraph, OuterJoinType optionalOuterJoinType, String[][][] uniqueIndexProps) {
        QueryPlanIndex[] indexSpecs = new QueryPlanIndex[2];
        QueryPlanNode[] execNodeSpecs = new QueryPlanNode[2];
        TableLookupPlan[] lookupPlans = new TableLookupPlan[2];
        Pair<QueryPlanIndex, TableLookupPlan> plan = TwoStreamQueryPlanBuilder.planQuery(1, 0, typesPerStream, queryGraph, uniqueIndexProps[0]);
        indexSpecs[0] = plan.getFirst();
        lookupPlans[1] = plan.getSecond();
        plan = TwoStreamQueryPlanBuilder.planQuery(0, 1, typesPerStream, queryGraph, uniqueIndexProps[1]);
        indexSpecs[1] = plan.getFirst();
        lookupPlans[0] = plan.getSecond();
        execNodeSpecs[0] = new TableLookupNode(lookupPlans[0]);
        execNodeSpecs[1] = new TableLookupNode(lookupPlans[1]);
        if (optionalOuterJoinType != null) {
            if (optionalOuterJoinType.equals((Object)OuterJoinType.LEFT) || optionalOuterJoinType.equals((Object)OuterJoinType.FULL)) {
                execNodeSpecs[0] = new TableOuterLookupNode(lookupPlans[0]);
            }
            if (optionalOuterJoinType.equals((Object)OuterJoinType.RIGHT) || optionalOuterJoinType.equals((Object)OuterJoinType.FULL)) {
                execNodeSpecs[1] = new TableOuterLookupNode(lookupPlans[1]);
            }
        }
        return new QueryPlan(indexSpecs, execNodeSpecs);
    }

    private static Pair<QueryPlanIndex, TableLookupPlan> planQuery(int lookupStream, int indexedStream, EventType[] typesPerStream, QueryGraph queryGraph, String[][] indexStreamsUniqueProps) {
        TableLookupPlan lookupPlan;
        String[] hashIndexProps;
        if (!queryGraph.isNavigableAtAll(lookupStream, indexedStream)) {
            QueryPlanIndex index = QueryPlanIndex.makeIndex(new QueryPlanIndexItem(null, null, null, null, false));
            FullTableScanLookupPlan plan = new FullTableScanLookupPlan(lookupStream, indexedStream, index.getFirstIndexNum());
            return new Pair<QueryPlanIndex, TableLookupPlan>(index, plan);
        }
        QueryGraphValue queryGraphValue = queryGraph.getGraphValue(lookupStream, indexedStream);
        QueryGraphValuePairHashKeyIndex hashKeyIndexPair = queryGraphValue.getHashKeyProps();
        List<QueryGraphValueEntryHashKeyed> hashKeyFunctions = hashKeyIndexPair.getKeys();
        CoercionDesc hashCoercionTypesDesc = CoercionUtil.getCoercionTypesHash(typesPerStream, lookupStream, indexedStream, hashKeyFunctions, hashIndexProps = hashKeyIndexPair.getIndexed());
        Class[] hashCoercionTypes = hashCoercionTypesDesc.isCoerce() ? hashCoercionTypesDesc.getCoercionTypes() : null;
        QueryGraphValuePairRangeIndex rangeKeyIndexPair = queryGraphValue.getRangeProps();
        String[] rangeIndexedProps = rangeKeyIndexPair.getIndexed();
        CoercionDesc rangeCoercionTypeDesc = CoercionUtil.getCoercionTypesRange(typesPerStream, indexedStream, rangeIndexedProps, rangeKeyIndexPair.getKeys());
        Class[] rangeCoercionType = rangeCoercionTypeDesc.isCoerce() ? rangeCoercionTypeDesc.getCoercionTypes() : null;
        boolean unique = false;
        QueryPlanIndexUniqueHelper.ReducedHashKeys reduced = QueryPlanIndexUniqueHelper.reduceToUniqueIfPossible(hashIndexProps, hashCoercionTypes, hashKeyFunctions, indexStreamsUniqueProps);
        if (reduced != null) {
            hashIndexProps = reduced.getPropertyNames();
            hashCoercionTypes = reduced.getCoercionTypes();
            hashKeyFunctions = reduced.getHashKeyFunctions();
            unique = true;
            rangeIndexedProps = new String[]{};
            rangeCoercionType = new Class[]{};
            rangeKeyIndexPair = new QueryGraphValuePairRangeIndex(rangeIndexedProps, Collections.<QueryGraphValueEntryRange>emptyList());
        }
        QueryPlanIndexItem indexItem = new QueryPlanIndexItem(hashIndexProps, hashCoercionTypes, rangeIndexedProps, rangeCoercionType, unique);
        QueryPlanIndex queryPlanIndex = QueryPlanIndex.makeIndex(indexItem);
        String indexName = queryPlanIndex.getFirstIndexNum();
        if (rangeKeyIndexPair.getKeys().isEmpty()) {
            if (hashKeyFunctions.size() == 1) {
                QueryGraphValueEntryHashKeyed first = hashKeyFunctions.get(0);
                lookupPlan = new IndexedTableLookupPlanSingle(lookupStream, indexedStream, indexName, first);
            } else {
                lookupPlan = new IndexedTableLookupPlanMulti(lookupStream, indexedStream, indexName, hashKeyFunctions);
            }
        } else {
            lookupPlan = hashKeyFunctions.isEmpty() && rangeKeyIndexPair.getKeys().size() == 1 ? new SortedTableLookupPlan(lookupStream, indexedStream, indexName, rangeKeyIndexPair.getKeys().get(0)) : new CompositeTableLookupPlan(lookupStream, indexedStream, indexName, hashKeyFunctions, rangeKeyIndexPair.getKeys());
        }
        return new Pair<QueryPlanIndex, TableLookupPlan>(queryPlanIndex, lookupPlan);
    }
}

