/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.pollindex;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableCoerceAllFactory;
import com.espertech.esper.epl.join.table.UnindexedEventTableList;
import java.util.Arrays;
import java.util.List;

public class PollResultIndexingStrategyIndexCoerce
implements PollResultIndexingStrategy {
    private final int streamNum;
    private final EventType eventType;
    private final String[] propertyNames;
    private final Class[] coercionTypes;

    public PollResultIndexingStrategyIndexCoerce(int streamNum, EventType eventType, String[] propertyNames, Class[] coercionTypes) {
        this.streamNum = streamNum;
        this.eventType = eventType;
        this.propertyNames = propertyNames;
        this.coercionTypes = coercionTypes;
    }

    @Override
    public EventTable index(List<EventBean> pollResult, boolean isActiveCache) {
        if (!isActiveCache) {
            return new UnindexedEventTableList(pollResult);
        }
        PropertyIndexedEventTableCoerceAllFactory factory = new PropertyIndexedEventTableCoerceAllFactory(this.streamNum, this.eventType, this.propertyNames, this.coercionTypes);
        EventTable table = factory.makeEventTable();
        table.add(pollResult.toArray(new EventBean[pollResult.size()]));
        return table;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " properties " + Arrays.toString(this.propertyNames) + " coercion " + Arrays.toString(this.coercionTypes);
    }
}

