/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.pollindex;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleCoerceAllFactory;
import com.espertech.esper.epl.join.table.UnindexedEventTableList;
import java.util.List;

public class PollResultIndexingStrategyIndexCoerceSingle
implements PollResultIndexingStrategy {
    private final int streamNum;
    private final EventType eventType;
    private final String propertyName;
    private final Class coercionType;

    public PollResultIndexingStrategyIndexCoerceSingle(int streamNum, EventType eventType, String propertyName, Class coercionType) {
        this.streamNum = streamNum;
        this.eventType = eventType;
        this.propertyName = propertyName;
        this.coercionType = coercionType;
    }

    @Override
    public EventTable index(List<EventBean> pollResult, boolean isActiveCache) {
        if (!isActiveCache) {
            return new UnindexedEventTableList(pollResult);
        }
        PropertyIndexedEventTableSingleCoerceAllFactory factory = new PropertyIndexedEventTableSingleCoerceAllFactory(this.streamNum, this.eventType, this.propertyName, this.coercionType);
        EventTable table = factory.makeEventTable();
        table.add(pollResult.toArray(new EventBean[pollResult.size()]));
        return table;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " property " + this.propertyName + " coercion " + this.coercionType;
    }
}

