/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.pollindex;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleFactory;
import com.espertech.esper.epl.join.table.UnindexedEventTableList;
import java.util.List;

public class PollResultIndexingStrategyIndexSingle
implements PollResultIndexingStrategy {
    private final int streamNum;
    private final EventType eventType;
    private final String propertyName;

    public PollResultIndexingStrategyIndexSingle(int streamNum, EventType eventType, String propertyName) {
        this.streamNum = streamNum;
        this.eventType = eventType;
        this.propertyName = propertyName;
    }

    @Override
    public EventTable index(List<EventBean> pollResult, boolean isActiveCache) {
        if (!isActiveCache) {
            return new UnindexedEventTableList(pollResult);
        }
        PropertyIndexedEventTableSingleFactory factory = new PropertyIndexedEventTableSingleFactory(this.streamNum, this.eventType, this.propertyName, false, null);
        EventTable table = factory.makeEventTable();
        table.add(pollResult.toArray(new EventBean[pollResult.size()]));
        return table;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " properties " + this.propertyName;
    }
}

