/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexEnterRemove;
import com.espertech.esper.epl.join.table.EventTable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyCompositeEventTable
implements EventTable {
    private final CompositeIndexEnterRemove chain;
    private final Class[] optKeyCoercedTypes;
    private final Class[] optRangeCoercedTypes;
    protected final Map<Object, Object> index;
    private static Log log = LogFactory.getLog(PropertyCompositeEventTable.class);

    public PropertyCompositeEventTable(boolean isHashKeyed, CompositeIndexEnterRemove chain, Class[] optKeyCoercedTypes, Class[] optRangeCoercedTypes) {
        this.chain = chain;
        this.optKeyCoercedTypes = optKeyCoercedTypes;
        this.optRangeCoercedTypes = optRangeCoercedTypes;
        this.index = isHashKeyed ? new HashMap<Object, Object>() : new TreeMap<Object, Object>();
    }

    public Map<Object, Object> getIndex() {
        return this.index;
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData) {
        this.add(newData);
        this.remove(oldData);
    }

    @Override
    public void add(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean theEvent : events) {
            this.add(theEvent);
        }
    }

    @Override
    public void remove(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean theEvent : events) {
            this.remove(theEvent);
        }
    }

    private void add(EventBean theEvent) {
        this.chain.enter(theEvent, this.index);
    }

    private void remove(EventBean theEvent) {
        this.chain.remove(theEvent, this.index);
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        LinkedHashSet<EventBean> result = new LinkedHashSet<EventBean>();
        this.chain.getAll(result, this.index);
        return result.iterator();
    }

    @Override
    public void clear() {
        this.index.clear();
    }

    public String toString() {
        return this.toQueryPlan();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getName();
    }

    public Class[] getOptRangeCoercedTypes() {
        return this.optRangeCoercedTypes;
    }

    public Class[] getOptKeyCoercedTypes() {
        return this.optKeyCoercedTypes;
    }
}

