/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableUnique;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyIndexedEventTableFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String[] propertyNames;
    protected final boolean unique;
    protected final String optionalIndexName;
    protected final EventPropertyGetter[] propertyGetters;
    private static Log log = LogFactory.getLog(PropertyIndexedEventTableFactory.class);

    public PropertyIndexedEventTableFactory(int streamNum, EventType eventType, String[] propertyNames, boolean unique, String optionalIndexName) {
        this.streamNum = streamNum;
        this.propertyNames = propertyNames;
        this.unique = unique;
        this.optionalIndexName = optionalIndexName;
        this.propertyGetters = new EventPropertyGetter[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            this.propertyGetters[i] = eventType.getGetter(propertyNames[i]);
        }
    }

    @Override
    public EventTable makeEventTable() {
        if (this.unique) {
            return new PropertyIndexedEventTableUnique(this.streamNum, this.propertyGetters, this.optionalIndexName);
        }
        return new PropertyIndexedEventTable(this.streamNum, this.propertyGetters);
    }

    @Override
    public Class getEventTableClass() {
        if (this.unique) {
            return PropertyIndexedEventTableUnique.class;
        }
        return PropertyIndexedEventTable.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + (this.unique ? " unique" : " non-unique") + " streamNum=" + this.streamNum + " propertyNames=" + Arrays.toString(this.propertyNames);
    }
}

