/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleUnique;
import com.espertech.esper.event.EventBeanUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyIndexedEventTableSingleFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String propertyName;
    protected final boolean unique;
    protected final String optionalIndexName;
    protected final EventPropertyGetter propertyGetter;
    private static Log log = LogFactory.getLog(PropertyIndexedEventTableSingleFactory.class);

    public PropertyIndexedEventTableSingleFactory(int streamNum, EventType eventType, String propertyName, boolean unique, String optionalIndexName) {
        this.streamNum = streamNum;
        this.propertyName = propertyName;
        this.unique = unique;
        this.optionalIndexName = optionalIndexName;
        this.propertyGetter = EventBeanUtility.getAssertPropertyGetter(eventType, propertyName);
    }

    @Override
    public EventTable makeEventTable() {
        if (this.unique) {
            return new PropertyIndexedEventTableSingleUnique(this.streamNum, this.propertyGetter, this.optionalIndexName);
        }
        return new PropertyIndexedEventTableSingle(this.streamNum, this.propertyGetter);
    }

    @Override
    public Class getEventTableClass() {
        if (this.unique) {
            return PropertyIndexedEventTableSingleUnique.class;
        }
        return PropertyIndexedEventTableSingle.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + (this.unique ? " unique" : " non-unique") + " streamNum=" + this.streamNum + " propertyName=" + this.propertyName;
    }
}

