/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableUnique;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyIndexedEventTableSingleUnique
extends PropertyIndexedEventTableSingle {
    private final String indexName;
    private final Map<Object, EventBean> propertyIndex;
    private static Log log = LogFactory.getLog(PropertyIndexedEventTableSingleUnique.class);

    public PropertyIndexedEventTableSingleUnique(int streamNum, EventPropertyGetter propertyGetter, String indexName) {
        super(streamNum, propertyGetter);
        this.indexName = indexName;
        this.propertyIndex = new HashMap<Object, EventBean>();
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData) {
        this.remove(oldData);
        this.add(newData);
    }

    @Override
    public void add(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean theEvent : events) {
            this.add(theEvent);
        }
    }

    @Override
    public void remove(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean theEvent : events) {
            this.remove(theEvent);
        }
    }

    @Override
    public Set<EventBean> lookup(Object key) {
        EventBean event = this.propertyIndex.get(key);
        if (event != null) {
            return Collections.singleton(event);
        }
        return null;
    }

    private void add(EventBean theEvent) {
        Object key = this.getKey(theEvent);
        EventBean existing = this.propertyIndex.put(key, theEvent);
        if (existing != null && !existing.equals(theEvent)) {
            throw PropertyIndexedEventTableUnique.handleUniqueIndexViolation(this.indexName, key);
        }
    }

    private void remove(EventBean theEvent) {
        Object key = this.getKey(theEvent);
        EventBean event = this.propertyIndex.get(key);
        if (event == null || !event.equals(theEvent)) {
            return;
        }
        this.propertyIndex.remove(key);
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.propertyIndex.values().iterator();
    }

    @Override
    public void clear() {
        this.propertyIndex.clear();
    }

    @Override
    public String toString() {
        return this.toQueryPlan();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum + " propertyGetter=" + this.propertyGetter;
    }
}

