/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyIndexedEventTableUnique
extends PropertyIndexedEventTable {
    private final String indexName;
    protected final Map<MultiKeyUntyped, EventBean> propertyIndex;
    private static Log log = LogFactory.getLog(PropertyIndexedEventTableUnique.class);

    public PropertyIndexedEventTableUnique(int streamNum, EventPropertyGetter[] propertyGetters, String indexName) {
        super(streamNum, propertyGetters);
        this.indexName = indexName;
        this.propertyIndex = new HashMap<MultiKeyUntyped, EventBean>();
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData) {
        this.remove(oldData);
        this.add(newData);
    }

    @Override
    public void add(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean theEvent : events) {
            this.add(theEvent);
        }
    }

    @Override
    public void remove(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean theEvent : events) {
            this.remove(theEvent);
        }
    }

    @Override
    public Set<EventBean> lookup(Object[] keys) {
        MultiKeyUntyped key = new MultiKeyUntyped(keys);
        EventBean event = this.propertyIndex.get(key);
        if (event != null) {
            return Collections.singleton(event);
        }
        return null;
    }

    private void add(EventBean theEvent) {
        MultiKeyUntyped key = this.getMultiKey(theEvent);
        EventBean existing = this.propertyIndex.put(key, theEvent);
        if (existing != null && !existing.equals(theEvent)) {
            throw PropertyIndexedEventTableUnique.handleUniqueIndexViolation(this.indexName, key);
        }
    }

    protected static EPException handleUniqueIndexViolation(String indexName, Object key) {
        String indexNameDisplay = indexName == null ? "" : " '" + indexName + "'";
        throw new EPException("Unique index violation, index" + indexNameDisplay + " is a unique index and key '" + key + "' already exists");
    }

    private void remove(EventBean theEvent) {
        MultiKeyUntyped key = this.getMultiKey(theEvent);
        EventBean event = this.propertyIndex.get(key);
        if (event == null || !event.equals(theEvent)) {
            return;
        }
        this.propertyIndex.remove(key);
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.propertyIndex.values().iterator();
    }

    @Override
    public void clear() {
        this.propertyIndex.clear();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum + " propertyGetters=" + Arrays.toString(this.propertyGetters);
    }
}

