/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.collection.SuperIterator;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValue;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueEquals;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueRange;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertySortedEventTableIterator;
import com.espertech.esper.filter.Range;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertySortedEventTable
implements EventTable {
    protected final int streamNum;
    protected final EventPropertyGetter propertyGetter;
    protected final TreeMap<Object, Set<EventBean>> propertyIndex;
    protected final HashSet<EventBean> nullKeyedValues;
    private static Log log = LogFactory.getLog(PropertySortedEventTable.class);

    protected Object coerce(Object value) {
        return value;
    }

    public PropertySortedEventTable(int streamNum, EventPropertyGetter propertyGetter) {
        this.streamNum = streamNum;
        this.propertyGetter = propertyGetter;
        this.propertyIndex = new TreeMap();
        this.nullKeyedValues = new LinkedHashSet<EventBean>();
    }

    protected Object getIndexedValue(EventBean theEvent) {
        return this.propertyGetter.get(theEvent);
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData) {
        this.add(newData);
        this.remove(oldData);
    }

    @Override
    public void add(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean theEvent : events) {
            this.add(theEvent);
        }
    }

    @Override
    public void remove(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (EventBean theEvent : events) {
            this.remove(theEvent);
        }
    }

    public Set<EventBean> lookupRange(Object keyStart, boolean includeStart, Object keyEnd, boolean includeEnd, boolean allowRangeReversal) {
        NavigableMap<Object, Set<EventBean>> submap;
        if (keyStart == null || keyEnd == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        keyEnd = this.coerce(keyEnd);
        try {
            submap = this.propertyIndex.subMap(keyStart, includeStart, keyEnd, includeEnd);
        }
        catch (IllegalArgumentException ex) {
            if (allowRangeReversal) {
                submap = this.propertyIndex.subMap(keyEnd, includeStart, keyStart, includeEnd);
            }
            return Collections.emptySet();
        }
        return this.normalize(submap);
    }

    public Collection<EventBean> lookupRangeColl(Object keyStart, boolean includeStart, Object keyEnd, boolean includeEnd, boolean allowRangeReversal) {
        NavigableMap<Object, Set<EventBean>> submap;
        if (keyStart == null || keyEnd == null) {
            return Collections.emptyList();
        }
        keyStart = this.coerce(keyStart);
        keyEnd = this.coerce(keyEnd);
        try {
            submap = this.propertyIndex.subMap(keyStart, includeStart, keyEnd, includeEnd);
        }
        catch (IllegalArgumentException ex) {
            if (allowRangeReversal) {
                submap = this.propertyIndex.subMap(keyEnd, includeStart, keyStart, includeEnd);
            }
            return Collections.emptyList();
        }
        return this.normalizeCollection(submap);
    }

    public Set<EventBean> lookupRangeInverted(Object keyStart, boolean includeStart, Object keyEnd, boolean includeEnd) {
        if (keyStart == null || keyEnd == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        keyEnd = this.coerce(keyEnd);
        NavigableMap<Object, Set<EventBean>> submapOne = this.propertyIndex.headMap(keyStart, !includeStart);
        NavigableMap<Object, Set<EventBean>> submapTwo = this.propertyIndex.tailMap(keyEnd, !includeEnd);
        return this.normalize(submapOne, submapTwo);
    }

    public Collection<EventBean> lookupRangeInvertedColl(Object keyStart, boolean includeStart, Object keyEnd, boolean includeEnd) {
        if (keyStart == null || keyEnd == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        keyEnd = this.coerce(keyEnd);
        NavigableMap<Object, Set<EventBean>> submapOne = this.propertyIndex.headMap(keyStart, !includeStart);
        NavigableMap<Object, Set<EventBean>> submapTwo = this.propertyIndex.tailMap(keyEnd, !includeEnd);
        return this.normalizeCollection(submapOne, submapTwo);
    }

    public Set<EventBean> lookupLess(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        return this.normalize(this.propertyIndex.headMap(keyStart));
    }

    public Collection<EventBean> lookupLessThenColl(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptyList();
        }
        keyStart = this.coerce(keyStart);
        return this.normalizeCollection(this.propertyIndex.headMap(keyStart));
    }

    public Set<EventBean> lookupLessEqual(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        return this.normalize(this.propertyIndex.headMap(keyStart, true));
    }

    public Collection<EventBean> lookupLessEqualColl(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptyList();
        }
        keyStart = this.coerce(keyStart);
        return this.normalizeCollection(this.propertyIndex.headMap(keyStart, true));
    }

    public Set<EventBean> lookupGreaterEqual(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        return this.normalize(this.propertyIndex.tailMap(keyStart));
    }

    public Collection<EventBean> lookupGreaterEqualColl(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptyList();
        }
        keyStart = this.coerce(keyStart);
        return this.normalizeCollection(this.propertyIndex.tailMap(keyStart));
    }

    public Set<EventBean> lookupGreater(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        return this.normalize(this.propertyIndex.tailMap(keyStart, false));
    }

    public Collection<EventBean> lookupGreaterColl(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptyList();
        }
        keyStart = this.coerce(keyStart);
        return this.normalizeCollection(this.propertyIndex.tailMap(keyStart, false));
    }

    private Set<EventBean> normalize(SortedMap<Object, Set<EventBean>> submap) {
        if (submap.size() == 0) {
            return null;
        }
        if (submap.size() == 1) {
            return (Set)submap.get(submap.firstKey());
        }
        LinkedHashSet<EventBean> result = new LinkedHashSet<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submap.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    private Collection<EventBean> normalizeCollection(SortedMap<Object, Set<EventBean>> submap) {
        if (submap.size() == 0) {
            return null;
        }
        if (submap.size() == 1) {
            return (Collection)submap.get(submap.firstKey());
        }
        ArrayDeque<EventBean> result = new ArrayDeque<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submap.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    private Collection<EventBean> normalizeCollection(SortedMap<Object, Set<EventBean>> submapOne, SortedMap<Object, Set<EventBean>> submapTwo) {
        if (submapOne.size() == 0) {
            return this.normalizeCollection(submapTwo);
        }
        if (submapTwo.size() == 0) {
            return this.normalizeCollection(submapOne);
        }
        ArrayDeque<EventBean> result = new ArrayDeque<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submapOne.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Object, Set<EventBean>> entry : submapTwo.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    private Set<EventBean> normalize(SortedMap<Object, Set<EventBean>> submapOne, SortedMap<Object, Set<EventBean>> submapTwo) {
        if (submapOne.size() == 0) {
            return this.normalize(submapTwo);
        }
        if (submapTwo.size() == 0) {
            return this.normalize(submapOne);
        }
        LinkedHashSet<EventBean> result = new LinkedHashSet<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submapOne.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Object, Set<EventBean>> entry : submapTwo.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    private void add(EventBean theEvent) {
        Object key = this.getIndexedValue(theEvent);
        if ((key = this.coerce(key)) == null) {
            this.nullKeyedValues.add(theEvent);
            return;
        }
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            events = new LinkedHashSet<EventBean>();
            this.propertyIndex.put(key, events);
        }
        events.add(theEvent);
    }

    private void remove(EventBean theEvent) {
        Object key = this.getIndexedValue(theEvent);
        if (key == null) {
            this.nullKeyedValues.remove(theEvent);
            return;
        }
        Set<EventBean> events = this.propertyIndex.get(key = this.coerce(key));
        if (events == null) {
            return;
        }
        if (!events.remove(theEvent)) {
            return;
        }
        if (events.isEmpty()) {
            this.propertyIndex.remove(key);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        if (this.nullKeyedValues.isEmpty()) {
            return new PropertySortedEventTableIterator(this.propertyIndex);
        }
        return new SuperIterator<EventBean>(new PropertySortedEventTableIterator(this.propertyIndex), this.nullKeyedValues.iterator());
    }

    @Override
    public void clear() {
        this.propertyIndex.clear();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum + " propertyGetter=" + this.propertyGetter;
    }

    public Set<EventBean> lookupConstants(RangeIndexLookupValue lookupValueBase) {
        if (lookupValueBase instanceof RangeIndexLookupValueEquals) {
            RangeIndexLookupValueEquals equals = (RangeIndexLookupValueEquals)lookupValueBase;
            return this.propertyIndex.get(equals.getValue());
        }
        RangeIndexLookupValueRange lookupValue = (RangeIndexLookupValueRange)lookupValueBase;
        if (lookupValue.getOperator() == QueryGraphRangeEnum.RANGE_CLOSED) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRange(range.getLowEndpoint(), true, range.getHighEndpoint(), true, lookupValue.isAllowRangeReverse());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.RANGE_HALF_OPEN) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRange(range.getLowEndpoint(), true, range.getHighEndpoint(), false, lookupValue.isAllowRangeReverse());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.RANGE_HALF_CLOSED) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRange(range.getLowEndpoint(), false, range.getHighEndpoint(), true, lookupValue.isAllowRangeReverse());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.RANGE_OPEN) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRange(range.getLowEndpoint(), false, range.getHighEndpoint(), false, lookupValue.isAllowRangeReverse());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.NOT_RANGE_CLOSED) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRangeInverted(range.getLowEndpoint(), true, range.getHighEndpoint(), true);
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.NOT_RANGE_HALF_OPEN) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRangeInverted(range.getLowEndpoint(), true, range.getHighEndpoint(), false);
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.NOT_RANGE_HALF_CLOSED) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRangeInverted(range.getLowEndpoint(), false, range.getHighEndpoint(), true);
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.NOT_RANGE_OPEN) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRangeInverted(range.getLowEndpoint(), false, range.getHighEndpoint(), false);
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.GREATER) {
            return this.lookupGreater(lookupValue.getValue());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.GREATER_OR_EQUAL) {
            return this.lookupGreaterEqual(lookupValue.getValue());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.LESS) {
            return this.lookupLess(lookupValue.getValue());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.LESS_OR_EQUAL) {
            return this.lookupLessEqual(lookupValue.getValue());
        }
        throw new IllegalArgumentException("Unrecognized operator '" + (Object)((Object)lookupValue.getOperator()) + "'");
    }
}

