/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import java.util.Collection;

public class SubordIndexedTableLookupStrategyExpr
implements SubordTableLookupStrategy {
    protected final PropertyIndexedEventTable index;
    protected final ExprEvaluator[] evaluators;
    private EventBean[] events;

    public SubordIndexedTableLookupStrategyExpr(int numStreamsOuter, ExprEvaluator[] evaluators, PropertyIndexedEventTable index) {
        this.evaluators = evaluators;
        this.events = new EventBean[numStreamsOuter + 1];
        this.index = index;
    }

    public PropertyIndexedEventTable getIndex() {
        return this.index;
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        Object[] keys = this.getKeys(eventsPerStream, context);
        return this.index.lookup(keys);
    }

    @Override
    public Collection<EventBean> lookup(Object[] keys) {
        return this.index.lookup(keys);
    }

    protected Object[] getKeys(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        System.arraycopy(eventsPerStream, 0, this.events, 1, eventsPerStream.length);
        Object[] keyValues = new Object[this.evaluators.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            keyValues[i] = this.evaluators[i].evaluate(this.events, true, context);
        }
        return keyValues;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " evaluators " + ExprNodeUtility.printEvaluators(this.evaluators);
    }
}

