/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.lookup.SubordIndexedTableLookupStrategyExpr;
import com.espertech.esper.epl.lookup.SubordIndexedTableLookupStrategyExprNW;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactory;
import java.util.List;

public class SubordIndexedTableLookupStrategyExprFactory
implements SubordTableLookupStrategyFactory {
    protected final ExprEvaluator[] evaluators;
    protected final boolean isNWOnTrigger;
    protected final int numStreamsOuter;

    public SubordIndexedTableLookupStrategyExprFactory(boolean isNWOnTrigger, int numStreamsOuter, List<SubordPropHashKey> hashKeys) {
        this.evaluators = new ExprEvaluator[hashKeys.size()];
        for (int i = 0; i < hashKeys.size(); ++i) {
            this.evaluators[i] = hashKeys.get(i).getHashKey().getKeyExpr().getExprEvaluator();
        }
        this.isNWOnTrigger = isNWOnTrigger;
        this.numStreamsOuter = numStreamsOuter;
    }

    @Override
    public SubordTableLookupStrategy makeStrategy(EventTable eventTable) {
        if (this.isNWOnTrigger) {
            return new SubordIndexedTableLookupStrategyExprNW(this.evaluators, (PropertyIndexedEventTable)eventTable);
        }
        return new SubordIndexedTableLookupStrategyExpr(this.numStreamsOuter, this.evaluators, (PropertyIndexedEventTable)eventTable);
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " evaluators " + ExprNodeUtility.printEvaluators(this.evaluators);
    }
}

