/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.metric;

import com.espertech.esper.client.metric.StatementMetric;
import com.espertech.esper.util.ManagedReadWriteLock;
import java.util.HashSet;
import java.util.Set;

public class StatementMetricArray {
    private final String engineURI;
    private final ManagedReadWriteLock rwLock;
    private final boolean isReportInactive;
    private String[] statementNames;
    private int currentLastElement;
    private volatile StatementMetric[] metrics;
    private Set<String> removedStatementNames;

    public StatementMetricArray(String engineURI, String name, int initialSize, boolean isReportInactive) {
        this.engineURI = engineURI;
        this.isReportInactive = isReportInactive;
        this.metrics = new StatementMetric[initialSize];
        this.statementNames = new String[initialSize];
        this.currentLastElement = -1;
        this.rwLock = new ManagedReadWriteLock("StatementMetricArray-" + name, true);
        this.removedStatementNames = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatement(String statementName) {
        this.rwLock.acquireWriteLock();
        try {
            this.removedStatementNames.add(statementName);
            if (this.removedStatementNames.size() > 1000) {
                for (int i = 0; i <= this.currentLastElement; ++i) {
                    if (!this.removedStatementNames.contains(this.statementNames[i])) continue;
                    this.statementNames[i] = null;
                }
                this.removedStatementNames.clear();
            }
        }
        finally {
            this.rwLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addStatementGetIndex(String statementName) {
        this.rwLock.acquireWriteLock();
        try {
            if (this.currentLastElement + 1 < this.metrics.length) {
                ++this.currentLastElement;
                this.statementNames[this.currentLastElement] = statementName;
                int n = this.currentLastElement;
                return n;
            }
            for (int i = 0; i < this.statementNames.length; ++i) {
                if (this.statementNames[i] != null) continue;
                this.statementNames[i] = statementName;
                if (i + 1 > this.currentLastElement) {
                    this.currentLastElement = i;
                }
                int n = i;
                return n;
            }
            int newSize = (int)((double)this.metrics.length * 1.5);
            String[] newStatementNames = new String[newSize];
            StatementMetric[] newMetrics = new StatementMetric[newSize];
            System.arraycopy(this.statementNames, 0, newStatementNames, 0, this.statementNames.length);
            System.arraycopy(this.metrics, 0, newMetrics, 0, this.metrics.length);
            this.statementNames = newStatementNames;
            this.metrics = newMetrics;
            ++this.currentLastElement;
            this.statementNames[this.currentLastElement] = statementName;
            int n = this.currentLastElement;
            return n;
        }
        finally {
            this.rwLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatementMetric[] flushMetrics() {
        this.rwLock.acquireWriteLock();
        try {
            int i;
            boolean isEmpty = false;
            if (this.currentLastElement == -1) {
                isEmpty = true;
            }
            if (this.isReportInactive) {
                for (i = 0; i <= this.currentLastElement; ++i) {
                    if (this.statementNames[i] == null) continue;
                    this.metrics[i] = new StatementMetric(this.engineURI, this.statementNames[i]);
                }
            }
            if (this.currentLastElement > -1 && !this.removedStatementNames.isEmpty()) {
                for (i = 0; i <= this.currentLastElement; ++i) {
                    if (!this.removedStatementNames.contains(this.statementNames[i])) continue;
                    this.statementNames[i] = null;
                }
            }
            while (this.currentLastElement != -1 && this.statementNames[this.currentLastElement] == null) {
                --this.currentLastElement;
            }
            if (isEmpty) {
                StatementMetric[] i2 = null;
                return i2;
            }
            StatementMetric[] newMetrics = new StatementMetric[this.metrics.length];
            StatementMetric[] oldMetrics = this.metrics;
            this.metrics = newMetrics;
            StatementMetric[] statementMetricArray = oldMetrics;
            return statementMetricArray;
        }
        finally {
            this.rwLock.releaseWriteLock();
        }
    }

    public ManagedReadWriteLock getRwLock() {
        return this.rwLock;
    }

    public StatementMetric getAddMetric(int index) {
        StatementMetric metric = this.metrics[index];
        if (metric == null) {
            this.metrics[index] = metric = new StatementMetric(this.engineURI, this.statementNames[index]);
        }
        return metric;
    }

    public int sizeLastElement() {
        return this.currentLastElement + 1;
    }
}

