/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.join.hint.IndexHint;
import com.espertech.esper.epl.join.hint.IndexHintInstruction;
import com.espertech.esper.epl.join.hint.IndexHintInstructionBust;
import com.espertech.esper.epl.join.hint.IndexHintInstructionExplicit;
import com.espertech.esper.epl.join.hint.IndexHintInstructionIndexName;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableAndNamePair;
import com.espertech.esper.epl.join.table.EventTableUtil;
import com.espertech.esper.epl.named.IndexMultiKey;
import com.espertech.esper.epl.named.IndexedPropDesc;
import com.espertech.esper.epl.named.NamedWindowIndexRepEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NamedWindowIndexRepository {
    private static final Log log = LogFactory.getLog(NamedWindowIndexRepository.class);
    private List<EventTable> tables = new ArrayList<EventTable>();
    private Map<IndexMultiKey, NamedWindowIndexRepEntry> tableIndexesRefCount = new HashMap<IndexMultiKey, NamedWindowIndexRepEntry>();

    public Pair<IndexMultiKey, EventTableAndNamePair> addExplicitIndexOrReuse(boolean unique, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, Iterable<EventBean> prefilledEvents, EventType indexedType, String indexName) {
        if (hashProps.isEmpty() && btreeProps.isEmpty()) {
            throw new IllegalArgumentException("Invalid zero element list for hash and btree columns");
        }
        IndexMultiKey indexPropKeyMatch = this.findExactMatchNameAndType(this.tableIndexesRefCount.keySet(), unique, hashProps, btreeProps);
        if (indexPropKeyMatch != null) {
            NamedWindowIndexRepEntry refTablePair = this.tableIndexesRefCount.get(indexPropKeyMatch);
            refTablePair.setRefCount(refTablePair.getRefCount() + 1);
            return new Pair<IndexMultiKey, EventTableAndNamePair>(indexPropKeyMatch, new EventTableAndNamePair(refTablePair.getTable(), refTablePair.getOptionalIndexName()));
        }
        return this.addIndex(unique, hashProps, btreeProps, prefilledEvents, indexedType, indexName, false);
    }

    public Pair<IndexMultiKey, EventTableAndNamePair> addTableCreateOrReuse(List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, Iterable<EventBean> prefilledEvents, EventType indexedType, IndexHint optionalIndexHint, boolean isIndexShare, int subqueryNumber, Set<String> optionalUniqueKeyProps) {
        boolean coerce;
        List<IndexHintInstruction> instructions;
        Map<IndexMultiKey, NamedWindowIndexRepEntry> indexCandidates;
        IndexMultiKey found;
        if (hashProps.isEmpty() && btreeProps.isEmpty()) {
            throw new IllegalArgumentException("Invalid zero element list for hash and btree columns");
        }
        if (optionalIndexHint != null && (found = this.handleIndexHint(indexCandidates = this.findCandidates(hashProps, btreeProps), instructions = optionalIndexHint.getInstructionsSubquery(subqueryNumber))) != null) {
            return this.reference(found);
        }
        IndexMultiKey indexPropKeyMatch = this.findExactMatchNameAndType(this.tableIndexesRefCount.keySet(), true, hashProps, btreeProps);
        if (indexPropKeyMatch == null) {
            indexPropKeyMatch = this.findExactMatchNameAndType(this.tableIndexesRefCount.keySet(), false, hashProps, btreeProps);
        }
        if (indexPropKeyMatch != null) {
            return this.reference(indexPropKeyMatch);
        }
        Map<IndexMultiKey, NamedWindowIndexRepEntry> indexCandidates2 = this.findCandidates(hashProps, btreeProps);
        if (!indexCandidates2.isEmpty()) {
            for (Map.Entry<IndexMultiKey, NamedWindowIndexRepEntry> indexKey : indexCandidates2.entrySet()) {
                if (!indexKey.getKey().isUnique()) continue;
                return this.reference(indexKey.getKey());
            }
        }
        boolean unique = false;
        boolean bl = coerce = !isIndexShare;
        if (optionalUniqueKeyProps != null && !optionalUniqueKeyProps.isEmpty()) {
            ArrayList<IndexedPropDesc> newHashProps = new ArrayList<IndexedPropDesc>();
            for (String uniqueKey : optionalUniqueKeyProps) {
                boolean found2 = false;
                for (IndexedPropDesc hashProp : hashProps) {
                    if (!hashProp.getIndexPropName().equals(uniqueKey)) continue;
                    newHashProps.add(hashProp);
                    found2 = true;
                    break;
                }
                if (found2) continue;
                newHashProps = null;
                break;
            }
            if (newHashProps != null) {
                hashProps = newHashProps;
                btreeProps = Collections.emptyList();
                unique = true;
                coerce = false;
            }
        }
        return this.addIndex(unique, hashProps, btreeProps, prefilledEvents, indexedType, null, coerce);
    }

    private IndexMultiKey handleIndexHint(Map<IndexMultiKey, NamedWindowIndexRepEntry> indexCandidates, List<IndexHintInstruction> instructions) {
        for (IndexHintInstruction instruction : instructions) {
            IndexMultiKey found;
            String indexName;
            IndexMultiKey found2;
            if (instruction instanceof IndexHintInstructionIndexName && (found2 = this.findExplicitIndexByName(indexCandidates, indexName = ((IndexHintInstructionIndexName)instruction).getIndexName())) != null) {
                return found2;
            }
            if (instruction instanceof IndexHintInstructionExplicit && (found = this.findExplicitIndexAnyName(indexCandidates)) != null) {
                return found;
            }
            if (!(instruction instanceof IndexHintInstructionBust)) continue;
            throw new EPException("Failed to plan index access, index hint busted out");
        }
        return null;
    }

    private Pair<IndexMultiKey, EventTableAndNamePair> reference(IndexMultiKey found) {
        NamedWindowIndexRepEntry refTablePair = this.tableIndexesRefCount.get(found);
        refTablePair.setRefCount(refTablePair.getRefCount() + 1);
        return new Pair<IndexMultiKey, EventTableAndNamePair>(found, new EventTableAndNamePair(refTablePair.getTable(), refTablePair.getOptionalIndexName()));
    }

    private IndexMultiKey findExplicitIndexByName(Map<IndexMultiKey, NamedWindowIndexRepEntry> indexCandidates, String name) {
        for (Map.Entry<IndexMultiKey, NamedWindowIndexRepEntry> entry : indexCandidates.entrySet()) {
            if (entry.getValue().getOptionalIndexName() == null || !entry.getValue().getOptionalIndexName().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    private IndexMultiKey findExplicitIndexAnyName(Map<IndexMultiKey, NamedWindowIndexRepEntry> indexCandidates) {
        for (Map.Entry<IndexMultiKey, NamedWindowIndexRepEntry> entry : indexCandidates.entrySet()) {
            if (entry.getValue().getOptionalIndexName() == null) continue;
            return entry.getKey();
        }
        return null;
    }

    private Map<IndexMultiKey, NamedWindowIndexRepEntry> findCandidates(List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps) {
        HashMap<IndexMultiKey, NamedWindowIndexRepEntry> indexCandidates = new HashMap<IndexMultiKey, NamedWindowIndexRepEntry>();
        for (Map.Entry<IndexMultiKey, NamedWindowIndexRepEntry> entry : this.tableIndexesRefCount.entrySet()) {
            boolean matches = this.indexMatchesProvided(entry.getKey(), hashProps, btreeProps);
            if (!matches) continue;
            indexCandidates.put(entry.getKey(), entry.getValue());
        }
        return indexCandidates;
    }

    private Pair<IndexMultiKey, EventTableAndNamePair> addIndex(boolean unique, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, Iterable<EventBean> prefilledEvents, EventType indexedType, String indexName, boolean mustCoerce) {
        IndexMultiKey indexPropKey = new IndexMultiKey(unique, hashProps, btreeProps);
        IndexedPropDesc[] indexedPropDescs = hashProps.toArray(new IndexedPropDesc[hashProps.size()]);
        String[] indexProps = IndexedPropDesc.getIndexProperties(indexedPropDescs);
        Class[] indexCoercionTypes = IndexedPropDesc.getCoercionTypes(indexedPropDescs);
        if (!mustCoerce) {
            indexCoercionTypes = null;
        }
        IndexedPropDesc[] rangePropDescs = btreeProps.toArray(new IndexedPropDesc[btreeProps.size()]);
        String[] rangeProps = IndexedPropDesc.getIndexProperties(rangePropDescs);
        Class[] rangeCoercionTypes = IndexedPropDesc.getCoercionTypes(rangePropDescs);
        QueryPlanIndexItem indexItem = new QueryPlanIndexItem(indexProps, indexCoercionTypes, rangeProps, rangeCoercionTypes, false);
        EventTable table = EventTableUtil.buildIndex(0, indexItem, indexedType, true, unique, indexName);
        EventBean[] events = new EventBean[1];
        Iterator<EventBean> i$ = prefilledEvents.iterator();
        while (i$.hasNext()) {
            EventBean prefilledEvent;
            events[0] = prefilledEvent = i$.next();
            table.add(events);
        }
        this.tables.add(table);
        this.tableIndexesRefCount.put(indexPropKey, new NamedWindowIndexRepEntry(table, indexName, 1));
        return new Pair<IndexMultiKey, EventTableAndNamePair>(indexPropKey, new EventTableAndNamePair(table, indexName));
    }

    private boolean indexMatchesProvided(IndexMultiKey indexDesc, List<IndexedPropDesc> hashPropsProvided, List<IndexedPropDesc> rangePropsProvided) {
        IndexedPropDesc[] rangePropIndexedList;
        IndexedPropDesc[] hashPropIndexedList;
        for (IndexedPropDesc hashPropIndexed : hashPropIndexedList = indexDesc.getHashIndexedProps()) {
            boolean foundHashProp = this.indexHashIsProvided(hashPropIndexed, hashPropsProvided);
            if (foundHashProp) continue;
            return false;
        }
        for (IndexedPropDesc rangePropIndexed : rangePropIndexedList = indexDesc.getRangeIndexedProps()) {
            boolean foundRangeProp = this.indexHashIsProvided(rangePropIndexed, rangePropsProvided);
            if (foundRangeProp) continue;
            return false;
        }
        return true;
    }

    private boolean indexHashIsProvided(IndexedPropDesc hashPropIndexed, List<IndexedPropDesc> hashPropsProvided) {
        for (IndexedPropDesc hashPropProvided : hashPropsProvided) {
            if (!hashPropProvided.getIndexPropName().equals(hashPropIndexed.getIndexPropName())) continue;
            return true;
        }
        return false;
    }

    private IndexMultiKey findExactMatchNameAndType(Set<IndexMultiKey> indexMultiKeys, boolean unique, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps) {
        for (IndexMultiKey existing : indexMultiKeys) {
            if (!this.isExactMatch(existing, unique, hashProps, btreeProps)) continue;
            return existing;
        }
        return null;
    }

    private boolean isExactMatch(IndexMultiKey existing, boolean unique, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps) {
        if (existing.isUnique() != unique) {
            return false;
        }
        boolean keyPropCompare = IndexedPropDesc.compare(Arrays.asList(existing.getHashIndexedProps()), hashProps);
        return keyPropCompare && IndexedPropDesc.compare(Arrays.asList(existing.getRangeIndexedProps()), btreeProps);
    }

    public void addTableReference(EventTable table) {
        for (Map.Entry<IndexMultiKey, NamedWindowIndexRepEntry> entry : this.tableIndexesRefCount.entrySet()) {
            if (entry.getValue().getTable() != table) continue;
            int current = entry.getValue().getRefCount() + 1;
            entry.getValue().setRefCount(current);
        }
    }

    public void removeTableReference(EventTable table) {
        for (Map.Entry<IndexMultiKey, NamedWindowIndexRepEntry> entry : this.tableIndexesRefCount.entrySet()) {
            if (entry.getValue().getTable() != table) continue;
            int current = entry.getValue().getRefCount();
            if (current > 1) {
                entry.getValue().setRefCount(--current);
                break;
            }
            this.tables.remove(table);
            this.tableIndexesRefCount.remove(entry.getKey());
            break;
        }
    }

    public List<EventTable> getTables() {
        return this.tables;
    }

    public void destroy() {
        this.tables.clear();
        this.tableIndexesRefCount.clear();
    }

    public Pair<IndexMultiKey, EventTableAndNamePair> findTable(Set<String> keyPropertyNames, Set<String> rangePropertyNames, Map<String, EventTable> explicitIndexNames, IndexHint optionalIndexHint) {
        List<IndexHintInstruction> instructions;
        IndexMultiKey found;
        if (keyPropertyNames.isEmpty() && rangePropertyNames.isEmpty()) {
            return null;
        }
        ArrayList<IndexedPropDesc> hashProps = new ArrayList<IndexedPropDesc>();
        for (String keyPropertyName : keyPropertyNames) {
            hashProps.add(new IndexedPropDesc(keyPropertyName, null));
        }
        ArrayList<IndexedPropDesc> rangeProps = new ArrayList<IndexedPropDesc>();
        for (String rangePropertyName : rangePropertyNames) {
            rangeProps.add(new IndexedPropDesc(rangePropertyName, null));
        }
        Map<IndexMultiKey, NamedWindowIndexRepEntry> indexCandidates = this.findCandidates(hashProps, rangeProps);
        if (optionalIndexHint != null && (found = this.handleIndexHint(indexCandidates, instructions = optionalIndexHint.getInstructionsFireAndForget())) != null) {
            return this.getPair(found);
        }
        if (indexCandidates == null || indexCandidates.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No index found.");
            }
            return null;
        }
        for (Map.Entry<IndexMultiKey, NamedWindowIndexRepEntry> entry : indexCandidates.entrySet()) {
            if (!entry.getKey().isUnique()) continue;
            return this.getPair(entry.getKey());
        }
        ArrayList<IndexMultiKey> indexes = new ArrayList<IndexMultiKey>(indexCandidates.keySet());
        if (indexes.size() > 1) {
            Comparator<IndexMultiKey> comparator = new Comparator<IndexMultiKey>(){

                @Override
                public int compare(IndexMultiKey o1, IndexMultiKey o2) {
                    String[] indexedProps2;
                    String[] indexedProps1 = IndexedPropDesc.getIndexProperties(o1.getHashIndexedProps());
                    if (indexedProps1.length > (indexedProps2 = IndexedPropDesc.getIndexProperties(o2.getHashIndexedProps())).length) {
                        return -1;
                    }
                    if (indexedProps1.length == indexedProps2.length) {
                        return 0;
                    }
                    return 1;
                }
            };
            Collections.sort(indexes, comparator);
        }
        IndexMultiKey indexMultiKey = (IndexMultiKey)indexes.get(0);
        return this.getPair(indexMultiKey);
    }

    private Pair<IndexMultiKey, EventTableAndNamePair> getPair(IndexMultiKey indexMultiKey) {
        NamedWindowIndexRepEntry indexFound = this.tableIndexesRefCount.get(indexMultiKey);
        EventTable tableFound = indexFound.getTable();
        return new Pair<IndexMultiKey, EventTableAndNamePair>(indexMultiKey, new EventTableAndNamePair(tableFound, indexFound.getOptionalIndexName()));
    }

    public IndexMultiKey[] getIndexDescriptors() {
        Set<IndexMultiKey> keySet = this.tableIndexesRefCount.keySet();
        return keySet.toArray(new IndexMultiKey[keySet.size()]);
    }
}

