/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.epl.named.IndexMultiKey;
import com.espertech.esper.epl.named.IndexedPropDesc;
import com.espertech.esper.epl.named.NamedWindowConsumerDesc;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.epl.named.NamedWindowService;
import com.espertech.esper.epl.named.NamedWindowTailView;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NamedWindowProcessor {
    private final String namedWindowName;
    private final NamedWindowTailView tailView;
    private final NamedWindowRootView rootView;
    private final String contextName;
    private final boolean singleInstanceContext;
    private final EventType eventType;
    private final String eplExpression;
    private final String statementName;
    private final boolean isEnableSubqueryIndexShare;
    private final boolean isVirtualDataWindow;
    private final StatementMetricHandle statementMetricHandle;
    private final Set<String> optionalUniqueKeyProps;
    private final Map<Integer, NamedWindowProcessorInstance> instances = new HashMap<Integer, NamedWindowProcessorInstance>();
    private NamedWindowProcessorInstance instanceNoContext;

    public NamedWindowProcessor(String namedWindowName, NamedWindowService namedWindowService, String contextName, boolean singleInstanceContext, EventType eventType, StatementResultService statementResultService, ValueAddEventProcessor revisionProcessor, String eplExpression, String statementName, boolean isPrioritized, boolean isEnableSubqueryIndexShare, boolean enableQueryPlanLog, MetricReportingService metricReportingService, boolean isBatchingDataWindow, boolean isVirtualDataWindow, StatementMetricHandle statementMetricHandle, Set<String> optionalUniqueKeyProps) {
        this.namedWindowName = namedWindowName;
        this.contextName = contextName;
        this.singleInstanceContext = singleInstanceContext;
        this.eventType = eventType;
        this.eplExpression = eplExpression;
        this.statementName = statementName;
        this.isEnableSubqueryIndexShare = isEnableSubqueryIndexShare;
        this.isVirtualDataWindow = isVirtualDataWindow;
        this.statementMetricHandle = statementMetricHandle;
        this.optionalUniqueKeyProps = optionalUniqueKeyProps;
        this.rootView = new NamedWindowRootView(revisionProcessor, enableQueryPlanLog, metricReportingService, eventType, isBatchingDataWindow, isEnableSubqueryIndexShare, optionalUniqueKeyProps);
        this.tailView = new NamedWindowTailView(eventType, namedWindowService, statementResultService, revisionProcessor, isPrioritized, isBatchingDataWindow);
    }

    public synchronized NamedWindowProcessorInstance addInstance(AgentInstanceContext agentInstanceContext) {
        if (this.contextName == null) {
            if (this.instanceNoContext != null) {
                throw new RuntimeException("Failed to allocated processor instance: already allocated and not released");
            }
            this.instanceNoContext = new NamedWindowProcessorInstance(null, this, agentInstanceContext);
            return this.instanceNoContext;
        }
        int instanceId = agentInstanceContext.getAgentInstanceId();
        NamedWindowProcessorInstance instance = new NamedWindowProcessorInstance(instanceId, this, agentInstanceContext);
        this.instances.put(instanceId, instance);
        return instance;
    }

    public synchronized void removeProcessorInstance(NamedWindowProcessorInstance instance) {
        if (this.contextName == null) {
            this.instanceNoContext = null;
            return;
        }
        this.instances.remove(instance.getAgentInstanceId());
    }

    public NamedWindowProcessorInstance getProcessorInstanceNoContext() {
        return this.instanceNoContext;
    }

    public synchronized Collection<Integer> getProcessorInstancesAll() {
        Set<Integer> keyset = this.instances.keySet();
        return new ArrayDeque<Integer>(keyset);
    }

    public NamedWindowProcessorInstance getProcessorInstance(int agentInstanceId) {
        return this.instances.get(agentInstanceId);
    }

    public long getProcessorRowCountDefaultInstance() {
        if (this.instanceNoContext != null) {
            return this.instanceNoContext.getCountDataWindow();
        }
        return -1L;
    }

    public NamedWindowProcessorInstance getProcessorInstance(AgentInstanceContext agentInstanceContext) {
        if (this.contextName == null) {
            return this.instanceNoContext;
        }
        if (this.singleInstanceContext) {
            if (this.instances.isEmpty()) {
                return null;
            }
            return this.instances.values().iterator().next();
        }
        if (agentInstanceContext.getStatementContext().getContextDescriptor() == null) {
            return null;
        }
        if (this.contextName.equals(agentInstanceContext.getStatementContext().getContextDescriptor().getContextName())) {
            return this.instances.get(agentInstanceContext.getAgentInstanceId());
        }
        return null;
    }

    public void validateOnExpressionContext(String onExprContextName) throws ExprValidationException {
        if (onExprContextName == null) {
            if (this.contextName != null) {
                throw new ExprValidationException("Cannot create on-trigger expression: Named window '" + this.namedWindowName + "' was declared with context '" + this.contextName + "', please declare the same context name");
            }
            return;
        }
        if (!onExprContextName.equals(this.contextName)) {
            throw new ExprValidationException("Cannot create on-trigger expression: Named window '" + this.namedWindowName + "' was declared with context '" + this.contextName + "', please use the same context instead");
        }
    }

    public String getContextName() {
        return this.contextName;
    }

    public NamedWindowConsumerView addConsumer(NamedWindowConsumerDesc consumerDesc, boolean isSubselect) {
        if (this.contextName != null) {
            ContextDescriptor contextDescriptor = consumerDesc.getAgentInstanceContext().getStatementContext().getContextDescriptor();
            if (contextDescriptor != null && this.contextName.equals(contextDescriptor.getContextName())) {
                NamedWindowProcessorInstance instance = this.instances.get(consumerDesc.getAgentInstanceContext().getAgentInstanceId());
                return instance.getTailViewInstance().addConsumer(consumerDesc, isSubselect);
            }
            return this.tailView.addConsumer(consumerDesc);
        }
        return this.instanceNoContext.getTailViewInstance().addConsumer(consumerDesc, isSubselect);
    }

    public boolean isVirtualDataWindow() {
        return this.isVirtualDataWindow;
    }

    public NamedWindowTailView getTailView() {
        return this.tailView;
    }

    public NamedWindowRootView getRootView() {
        return this.rootView;
    }

    public EventType getNamedWindowType() {
        return this.eventType;
    }

    public String getEplExpression() {
        return this.eplExpression;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public void destroy() {
    }

    public boolean isEnableSubqueryIndexShare() {
        return this.isEnableSubqueryIndexShare;
    }

    public StatementMetricHandle getCreateNamedWindowMetricsHandle() {
        return this.statementMetricHandle;
    }

    public String getNamedWindowName() {
        return this.namedWindowName;
    }

    public String[][] getUniqueIndexes(NamedWindowProcessorInstance processorInstance) {
        ArrayList<String[]> unique = null;
        if (processorInstance != null) {
            IndexMultiKey[] indexDescriptors;
            for (IndexMultiKey index : indexDescriptors = processorInstance.getIndexDescriptors()) {
                if (!index.isUnique()) continue;
                String[] uniqueKeys = IndexedPropDesc.getIndexProperties(index.getHashIndexedProps());
                if (unique == null) {
                    unique = new ArrayList();
                }
                unique.add(uniqueKeys);
            }
        }
        if (this.optionalUniqueKeyProps != null) {
            if (unique == null) {
                unique = new ArrayList<String[]>();
            }
            unique.add(this.optionalUniqueKeyProps.toArray(new String[this.optionalUniqueKeyProps.size()]));
        }
        if (unique == null) {
            return null;
        }
        return (String[][])unique.toArray((T[])new String[unique.size()][]);
    }

    public Set<String> getOptionalUniqueKeyProps() {
        return this.optionalUniqueKeyProps;
    }
}

