/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValue;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueEquals;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueRange;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexLookup;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexLookupFactory;
import com.espertech.esper.epl.join.hint.IndexHint;
import com.espertech.esper.epl.join.plan.CoercionDesc;
import com.espertech.esper.epl.join.plan.QueryGraphRangeConsolidateDesc;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.epl.join.plan.QueryGraphRangeUtil;
import com.espertech.esper.epl.join.plan.QueryPlanIndexBuilder;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableAndNamePair;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.join.table.PropertySortedEventTable;
import com.espertech.esper.epl.join.util.QueryPlanIndexDescFAF;
import com.espertech.esper.epl.join.util.QueryPlanIndexDescOnExpr;
import com.espertech.esper.epl.join.util.QueryPlanIndexDescSubquery;
import com.espertech.esper.epl.join.util.QueryPlanIndexHook;
import com.espertech.esper.epl.join.util.QueryPlanIndexHookUtil;
import com.espertech.esper.epl.lookup.SubordFullTableScanLookupStrategyLocking;
import com.espertech.esper.epl.lookup.SubordIndexedTableLookupStrategyLocking;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import com.espertech.esper.epl.lookup.SubordPropPlan;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.epl.lookup.SubordinateTableLookupStrategyUtil;
import com.espertech.esper.epl.named.IndexKeyInfo;
import com.espertech.esper.epl.named.IndexMultiKey;
import com.espertech.esper.epl.named.IndexedPropDesc;
import com.espertech.esper.epl.named.NamedWindowIndexRepository;
import com.espertech.esper.epl.named.NamedWindowLookupStrategy;
import com.espertech.esper.epl.named.NamedWindowLookupStrategyAllRows;
import com.espertech.esper.epl.named.NamedWindowLookupStrategyIndexed;
import com.espertech.esper.epl.named.NamedWindowLookupStrategyIndexedUnfiltered;
import com.espertech.esper.epl.named.NamedWindowLookupStrategyTableScan;
import com.espertech.esper.epl.named.NamedWindowOnExprBaseView;
import com.espertech.esper.epl.named.NamedWindowOnExprFactory;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.epl.spec.CreateIndexItem;
import com.espertech.esper.epl.spec.CreateIndexType;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.filter.DoubleRange;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamConstant;
import com.espertech.esper.filter.FilterSpecParamRange;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NamedWindowRootViewInstance
extends ViewSupport {
    private static final Log log = LogFactory.getLog(NamedWindowRootViewInstance.class);
    private final NamedWindowRootView rootView;
    private final AgentInstanceContext agentInstanceContext;
    private final NamedWindowIndexRepository indexRepository;
    private final Map<NamedWindowLookupStrategy, EventTable> tablePerMultiLookup;
    private final Map<SubordTableLookupStrategy, EventTable> tablePerSingleLookup;
    private final ConcurrentHashMap<String, EventTable> explicitIndexes;
    private Iterable<EventBean> dataWindowContents;

    public NamedWindowRootViewInstance(NamedWindowRootView rootView, AgentInstanceContext agentInstanceContext) {
        this.rootView = rootView;
        this.agentInstanceContext = agentInstanceContext;
        this.indexRepository = new NamedWindowIndexRepository();
        this.tablePerMultiLookup = new HashMap<NamedWindowLookupStrategy, EventTable>();
        this.tablePerSingleLookup = new HashMap<SubordTableLookupStrategy, EventTable>();
        this.explicitIndexes = new ConcurrentHashMap();
    }

    public IndexMultiKey[] getIndexes() {
        return this.indexRepository.getIndexDescriptors();
    }

    public void setDataWindowContents(Iterable<EventBean> dataWindowContents) {
        this.dataWindowContents = dataWindowContents;
    }

    public void removeOldData(EventBean[] oldData) {
        if (this.rootView.getRevisionProcessor() != null) {
            this.rootView.getRevisionProcessor().removeOldData(oldData, this.indexRepository);
        } else {
            for (EventTable table : this.indexRepository.getTables()) {
                table.remove(oldData);
            }
        }
    }

    public void addNewData(EventBean[] newData) {
        if (this.rootView.getRevisionProcessor() == null) {
            for (EventTable table : this.indexRepository.getTables()) {
                table.add(newData);
            }
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (this.rootView.getRevisionProcessor() != null) {
            this.rootView.getRevisionProcessor().onUpdate(newData, oldData, this, this.indexRepository);
        } else {
            for (EventTable table : this.indexRepository.getTables()) {
                if (!this.rootView.isChildBatching()) continue;
                table.add(newData);
            }
            this.updateChildren(newData, oldData);
        }
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
    }

    @Override
    public EventType getEventType() {
        return this.rootView.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return null;
    }

    public void destroy() {
        this.indexRepository.destroy();
        this.tablePerMultiLookup.clear();
        this.tablePerSingleLookup.clear();
    }

    public Collection<EventBean> snapshot(FilterSpecCompiled optionalFilter, Annotation[] annotations) {
        Set<EventBean> result;
        Pair<IndexMultiKey, EventTableAndNamePair> tablePair;
        VirtualDWView virtualDataWindow = null;
        if (this.isVirtualDataWindow()) {
            virtualDataWindow = this.getVirtualDataWindow();
        }
        if (optionalFilter == null || optionalFilter.getParameters().length == 0) {
            if (virtualDataWindow != null) {
                Pair<IndexMultiKey, EventTable> pair = virtualDataWindow.getFireAndForgetDesc(Collections.<String>emptySet(), Collections.<String>emptySet());
                return virtualDataWindow.getFireAndForgetData(pair.getSecond(), new Object[0], new RangeIndexLookupValue[0], annotations);
            }
            return null;
        }
        HashSet<String> keysAvailable = new HashSet<String>();
        HashSet<String> rangesAvailable = new HashSet<String>();
        for (FilterSpecParam param : optionalFilter.getParameters()) {
            if (!(param instanceof FilterSpecParamConstant) && !(param instanceof FilterSpecParamRange)) continue;
            if (param.getFilterOperator() == FilterOperator.EQUAL || param.getFilterOperator() == FilterOperator.IS) {
                keysAvailable.add(param.getLookupable().getExpression());
                continue;
            }
            if (param.getFilterOperator().isRangeOperator() || param.getFilterOperator().isInvertedRangeOperator() || param.getFilterOperator().isComparisonOperator()) {
                rangesAvailable.add(param.getLookupable().getExpression());
                continue;
            }
            if (!param.getFilterOperator().isRangeOperator()) continue;
            rangesAvailable.add(param.getLookupable().getExpression());
        }
        if (virtualDataWindow != null) {
            Pair<IndexMultiKey, EventTable> tablePairNoName = virtualDataWindow.getFireAndForgetDesc(keysAvailable, rangesAvailable);
            tablePair = new Pair<IndexMultiKey, EventTableAndNamePair>(tablePairNoName.getFirst(), new EventTableAndNamePair(tablePairNoName.getSecond(), null));
        } else {
            IndexHint indexHint = IndexHint.getIndexHint(annotations);
            tablePair = this.indexRepository.findTable(keysAvailable, rangesAvailable, this.explicitIndexes, indexHint);
        }
        if (this.rootView.isQueryPlanLogging()) {
            NamedWindowRootViewInstance namedWindowRootViewInstance = this;
            if (namedWindowRootViewInstance.rootView.getQueryPlanLog().isInfoEnabled()) {
                String prefix = "Fire-and-forget from window " + this.rootView.getEventType().getName() + " ";
                String indexName = tablePair != null && tablePair.getSecond() != null ? tablePair.getSecond().getIndexName() : null;
                String indexText = indexName != null ? "index " + indexName + " " : "full table scan ";
                indexText = indexText + "(snapshot only, for join see separate query plan)";
                if (tablePair == null) {
                    NamedWindowRootViewInstance namedWindowRootViewInstance2 = this;
                    namedWindowRootViewInstance2.rootView.getQueryPlanLog().info((Object)(prefix + indexText));
                } else {
                    NamedWindowRootViewInstance namedWindowRootViewInstance3 = this;
                    namedWindowRootViewInstance3.rootView.getQueryPlanLog().info((Object)(prefix + indexText + tablePair.getSecond().getEventTable().toQueryPlan()));
                }
                QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(annotations);
                if (hook != null) {
                    hook.fireAndForget(new QueryPlanIndexDescFAF(indexName, tablePair != null ? tablePair.getSecond().getEventTable().getClass().getSimpleName() : null));
                }
            }
        }
        if (tablePair == null) {
            return null;
        }
        String[] keyIndexProps = IndexedPropDesc.getIndexProperties(tablePair.getFirst().getHashIndexedProps());
        Object[] keyValues = new Object[keyIndexProps.length];
        block1: for (int keyIndex = 0; keyIndex < keyIndexProps.length; ++keyIndex) {
            for (FilterSpecParam param : optionalFilter.getParameters()) {
                if (!param.getLookupable().getExpression().equals(keyIndexProps[keyIndex])) continue;
                keyValues[keyIndex] = param.getFilterValue(null, this.agentInstanceContext);
                continue block1;
            }
        }
        String[] rangeIndexProps = IndexedPropDesc.getIndexProperties(tablePair.getFirst().getRangeIndexedProps());
        RangeIndexLookupValue[] rangeValues = rangeIndexProps.length > 0 ? this.compileRangeLookupValues(rangeIndexProps, optionalFilter.getParameters()) : new RangeIndexLookupValue[]{};
        EventTable eventTable = tablePair.getSecond().getEventTable();
        if (virtualDataWindow != null) {
            return virtualDataWindow.getFireAndForgetData(eventTable, keyValues, rangeValues, annotations);
        }
        IndexMultiKey indexMultiKey = tablePair.getFirst();
        if (indexMultiKey.getHashIndexedProps().length > 0 && indexMultiKey.getRangeIndexedProps().length == 0) {
            if (indexMultiKey.getHashIndexedProps().length == 1) {
                PropertyIndexedEventTableSingle table = (PropertyIndexedEventTableSingle)eventTable;
                result = table.lookup(keyValues[0]);
            } else {
                PropertyIndexedEventTable table = (PropertyIndexedEventTable)eventTable;
                result = table.lookup(keyValues);
            }
        } else if (indexMultiKey.getHashIndexedProps().length == 0 && indexMultiKey.getRangeIndexedProps().length == 1) {
            PropertySortedEventTable table = (PropertySortedEventTable)eventTable;
            result = table.lookupConstants(rangeValues[0]);
        } else {
            PropertyCompositeEventTable table = (PropertyCompositeEventTable)eventTable;
            Class[] rangeCoercion = table.getOptRangeCoercedTypes();
            CompositeIndexLookup lookup = CompositeIndexLookupFactory.make(keyValues, rangeValues, rangeCoercion);
            result = new HashSet<EventBean>();
            lookup.lookup(table.getIndex(), result);
        }
        if (result != null) {
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private RangeIndexLookupValue[] compileRangeLookupValues(String[] rangeIndexProps, FilterSpecParam[] parameters) {
        RangeIndexLookupValue[] result = new RangeIndexLookupValue[rangeIndexProps.length];
        for (int rangeIndex = 0; rangeIndex < rangeIndexProps.length; ++rangeIndex) {
            for (FilterSpecParam param : parameters) {
                RangeIndexLookupValueRange existingRange;
                QueryGraphRangeEnum opExist;
                QueryGraphRangeConsolidateDesc desc;
                if (!param.getLookupable().getExpression().equals(rangeIndexProps[rangeIndex])) continue;
                if (param.getFilterOperator() == FilterOperator.EQUAL || param.getFilterOperator() == FilterOperator.IS) {
                    result[rangeIndex] = new RangeIndexLookupValueEquals(param.getFilterValue(null, this.agentInstanceContext));
                    continue;
                }
                if (param.getFilterOperator().isRangeOperator() || param.getFilterOperator().isInvertedRangeOperator()) {
                    QueryGraphRangeEnum opAdd = QueryGraphRangeEnum.mapFrom(param.getFilterOperator());
                    result[rangeIndex] = new RangeIndexLookupValueRange(param.getFilterValue(null, this.agentInstanceContext), opAdd, true);
                    continue;
                }
                if (!param.getFilterOperator().isComparisonOperator()) continue;
                RangeIndexLookupValue existing = result[rangeIndex];
                QueryGraphRangeEnum opAdd = QueryGraphRangeEnum.mapFrom(param.getFilterOperator());
                if (existing == null) {
                    result[rangeIndex] = new RangeIndexLookupValueRange(param.getFilterValue(null, this.agentInstanceContext), opAdd, true);
                    continue;
                }
                if (!(existing instanceof RangeIndexLookupValueRange) || (desc = QueryGraphRangeUtil.getCanConsolidate(opExist = (existingRange = (RangeIndexLookupValueRange)existing).getOperator(), opAdd)) == null) continue;
                DoubleRange doubleRange = this.getDoubleRange(desc.isReverse(), existing.getValue(), param.getFilterValue(null, this.agentInstanceContext));
                result[rangeIndex] = new RangeIndexLookupValueRange(doubleRange, desc.getType(), false);
            }
        }
        return result;
    }

    public synchronized void addExplicitIndex(boolean unique, String namedWindowName, String indexName, List<CreateIndexItem> columns) throws ExprValidationException {
        if (this.explicitIndexes.containsKey(indexName)) {
            throw new ExprValidationException("Index by name '" + indexName + "' already exists");
        }
        ArrayList<IndexedPropDesc> hashProps = new ArrayList<IndexedPropDesc>();
        ArrayList<IndexedPropDesc> btreeProps = new ArrayList<IndexedPropDesc>();
        HashSet<String> indexed = new HashSet<String>();
        for (CreateIndexItem columnDesc : columns) {
            String columnName = columnDesc.getName();
            Class type = JavaClassHelper.getBoxedType(this.rootView.getEventType().getPropertyType(columnName));
            if (type == null) {
                throw new ExprValidationException("Property named '" + columnName + "' not found on named window '" + namedWindowName + "'");
            }
            if (!indexed.add(columnName)) {
                throw new ExprValidationException("Property named '" + columnName + "' has been declared more then once");
            }
            IndexedPropDesc desc = new IndexedPropDesc(columnName, type);
            if (columnDesc.getType() == CreateIndexType.HASH) {
                hashProps.add(desc);
                continue;
            }
            btreeProps.add(desc);
        }
        if (unique && !btreeProps.isEmpty()) {
            throw new ExprValidationException("Combination of unique index with btree (range) is not supported");
        }
        Pair<IndexMultiKey, EventTableAndNamePair> pair = this.indexRepository.addExplicitIndexOrReuse(unique, hashProps, btreeProps, this.dataWindowContents, this.rootView.getEventType(), indexName);
        this.explicitIndexes.put(indexName, pair.getSecond().getEventTable());
    }

    public NamedWindowOnExprBaseView addOnExpr(NamedWindowOnExprFactory onExprFactory, AgentInstanceContext agentInstanceContext, ExprNode joinExpr, EventType filterEventType, ResultSetProcessor resultSetProcessor) {
        IndexHint indexHint = IndexHint.getIndexHint(agentInstanceContext.getStatementContext().getAnnotations());
        Pair<NamedWindowLookupStrategy, EventTableAndNamePair> strategy = this.getStrategyPair(agentInstanceContext.getStatementContext().getStatementName(), agentInstanceContext.getStatementContext().getStatementId(), agentInstanceContext.getStatementContext().getAnnotations(), joinExpr, filterEventType, indexHint, this.rootView.isEnableIndexShare(), -1);
        if (this.rootView.isQueryPlanLogging()) {
            NamedWindowRootViewInstance namedWindowRootViewInstance = this;
            if (namedWindowRootViewInstance.rootView.getQueryPlanLog().isInfoEnabled()) {
                String prefix = "On-Expr ";
                String indexName = strategy.getSecond() != null ? strategy.getSecond().getIndexName() : null;
                String indexText = indexName != null ? "index " + indexName + " " : "(implicit) ";
                NamedWindowRootViewInstance namedWindowRootViewInstance2 = this;
                namedWindowRootViewInstance2.rootView.getQueryPlanLog().info((Object)(prefix + "strategy " + strategy.getFirst().toQueryPlan()));
                NamedWindowRootViewInstance namedWindowRootViewInstance3 = this;
                namedWindowRootViewInstance3.rootView.getQueryPlanLog().info((Object)(prefix + indexText + "table " + (strategy.getSecond() == null ? "N/A" : strategy.getSecond().getEventTable().toQueryPlan())));
                QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(agentInstanceContext.getStatementContext().getAnnotations());
                if (hook != null) {
                    hook.namedWindowOnExpr(new QueryPlanIndexDescOnExpr(strategy.getSecond().getIndexName(), strategy.getSecond().getEventTable().getClass().getSimpleName()));
                }
            }
        }
        if (strategy.getSecond() != null) {
            this.tablePerMultiLookup.put(strategy.getFirst(), strategy.getSecond().getEventTable());
        }
        return onExprFactory.make(strategy.getFirst(), this, agentInstanceContext, resultSetProcessor);
    }

    public void removeOnExpr(NamedWindowLookupStrategy strategy) {
        EventTable table = this.tablePerMultiLookup.remove(strategy);
        if (table != null) {
            this.indexRepository.removeTableReference(table);
        }
    }

    private Pair<IndexKeyInfo, EventTableAndNamePair> findCreateIndex(SubordPropPlan joinDesc, IndexHint optionalIndexHint, boolean isIndexShare, int subqueryNumber) {
        Pair<IndexMultiKey, EventTableAndNamePair> tableDesc;
        int i;
        String[] hashIndexPropsProvided = new String[joinDesc.getHashProps().size()];
        Class[] hashIndexCoercionType = new Class[joinDesc.getHashProps().size()];
        SubordPropHashKey[] hashJoinedProps = new SubordPropHashKey[joinDesc.getHashProps().size()];
        int count = 0;
        for (Map.Entry<String, SubordPropHashKey> entry : joinDesc.getHashProps().entrySet()) {
            hashIndexPropsProvided[count] = entry.getKey();
            hashIndexCoercionType[count] = entry.getValue().getCoercionType();
            hashJoinedProps[count++] = entry.getValue();
        }
        String[] rangeIndexPropsProvided = new String[joinDesc.getRangeProps().size()];
        Class[] rangeIndexCoercionType = new Class[joinDesc.getRangeProps().size()];
        SubordPropRangeKey[] rangeJoinedProps = new SubordPropRangeKey[joinDesc.getRangeProps().size()];
        count = 0;
        for (Map.Entry<String, SubordPropRangeKey> entry : joinDesc.getRangeProps().entrySet()) {
            rangeIndexPropsProvided[count] = entry.getKey();
            rangeIndexCoercionType[count] = entry.getValue().getCoercionType();
            rangeJoinedProps[count++] = entry.getValue();
        }
        ArrayList<IndexedPropDesc> hashedProps = new ArrayList<IndexedPropDesc>();
        ArrayList<IndexedPropDesc> btreeProps = new ArrayList<IndexedPropDesc>();
        for (i = 0; i < hashIndexPropsProvided.length; ++i) {
            hashedProps.add(new IndexedPropDesc(hashIndexPropsProvided[i], hashIndexCoercionType[i]));
        }
        for (i = 0; i < rangeIndexPropsProvided.length; ++i) {
            btreeProps.add(new IndexedPropDesc(rangeIndexPropsProvided[i], rangeIndexCoercionType[i]));
        }
        if (this.isVirtualDataWindow()) {
            VirtualDWView viewExternal = this.getVirtualDataWindow();
            Pair<IndexMultiKey, EventTable> tableVW = viewExternal.getSubordinateQueryDesc(false, hashedProps, btreeProps);
            tableDesc = new Pair<IndexMultiKey, EventTableAndNamePair>(tableVW.getFirst(), new EventTableAndNamePair(tableVW.getSecond(), null));
        } else {
            if (joinDesc.getHashProps().isEmpty() && joinDesc.getRangeProps().isEmpty()) {
                return null;
            }
            tableDesc = this.indexRepository.addTableCreateOrReuse(hashedProps, btreeProps, this.dataWindowContents, this.rootView.getEventType(), optionalIndexHint, isIndexShare, subqueryNumber, this.rootView.getOptionalUniqueKeyProps());
        }
        IndexedPropDesc[] indexedKeyProps = tableDesc.getFirst().getHashIndexedProps();
        SubordPropHashKey[] hashesDesc = new SubordPropHashKey[indexedKeyProps.length];
        Class[] hashPropCoercionTypes = new Class[indexedKeyProps.length];
        boolean isCoerceHash = false;
        for (int i2 = 0; i2 < indexedKeyProps.length; ++i2) {
            String indexField = indexedKeyProps[i2].getIndexPropName();
            int index = CollectionUtil.findItem(hashIndexPropsProvided, indexField);
            if (index == -1) {
                throw new IllegalStateException("Could not find index property for lookup '" + indexedKeyProps[i2]);
            }
            hashesDesc[i2] = hashJoinedProps[index];
            hashPropCoercionTypes[i2] = indexedKeyProps[i2].getCoercionType();
            ExprEvaluator evaluatorHashkey = hashesDesc[i2].getHashKey().getKeyExpr().getExprEvaluator();
            if (evaluatorHashkey == null || indexedKeyProps[i2].getCoercionType() == evaluatorHashkey.getType()) continue;
            isCoerceHash = true;
        }
        indexedKeyProps = tableDesc.getFirst().getRangeIndexedProps();
        SubordPropRangeKey[] rangesDesc = new SubordPropRangeKey[indexedKeyProps.length];
        Class[] rangePropCoercionTypes = new Class[indexedKeyProps.length];
        boolean isCoerceRange = false;
        for (int i3 = 0; i3 < indexedKeyProps.length; ++i3) {
            String indexField = indexedKeyProps[i3].getIndexPropName();
            int index = CollectionUtil.findItem(rangeIndexPropsProvided, indexField);
            if (index == -1) {
                throw new IllegalStateException("Could not find range property for lookup '" + indexedKeyProps[i3]);
            }
            rangesDesc[i3] = rangeJoinedProps[index];
            rangePropCoercionTypes[i3] = rangeJoinedProps[index].getCoercionType();
            if (indexedKeyProps[i3].getCoercionType() == rangePropCoercionTypes[i3]) continue;
            isCoerceRange = true;
        }
        IndexKeyInfo info = new IndexKeyInfo(Arrays.asList(hashesDesc), new CoercionDesc(isCoerceHash, hashPropCoercionTypes), Arrays.asList(rangesDesc), new CoercionDesc(isCoerceRange, rangePropCoercionTypes));
        return new Pair<IndexKeyInfo, EventTableAndNamePair>(info, tableDesc.getSecond());
    }

    private Pair<SubordTableLookupStrategy, EventTableAndNamePair> getSubqueryStrategyPair(String accessedByStatementName, String accessedByStatementId, Annotation[] accessedByStmtAnnotations, EventType[] outerStreamTypes, SubordPropPlan joinDesc, boolean isNWOnTrigger, boolean forceTableScan, IndexHint optionalIndexHint, boolean isIndexShare, int subqueryNumber) {
        SubordTableLookupStrategy lookupStrategy;
        Pair<IndexKeyInfo, EventTableAndNamePair> accessDesc = this.findCreateIndex(joinDesc, optionalIndexHint, isIndexShare, subqueryNumber);
        if (accessDesc == null) {
            return null;
        }
        IndexKeyInfo indexKeyInfo = accessDesc.getFirst();
        EventTableAndNamePair eventTableAndName = accessDesc.getSecond();
        EventTable eventTable = accessDesc.getSecond().getEventTable();
        List<SubordPropHashKey> hashKeys = indexKeyInfo.getOrderedHashProperties();
        CoercionDesc hashKeyCoercionTypes = indexKeyInfo.getOrderedKeyCoercionTypes();
        List<SubordPropRangeKey> rangeKeys = indexKeyInfo.getOrderedRangeDesc();
        CoercionDesc rangeKeyCoercionTypes = indexKeyInfo.getOrderedRangeCoercionTypes();
        if (this.isVirtualDataWindow()) {
            VirtualDWView viewExternal = this.getVirtualDataWindow();
            lookupStrategy = viewExternal.getSubordinateLookupStrategy(accessedByStatementName, accessedByStatementId, accessedByStmtAnnotations, outerStreamTypes, hashKeys, hashKeyCoercionTypes, rangeKeys, rangeKeyCoercionTypes, isNWOnTrigger, eventTable, joinDesc, forceTableScan);
        } else if (forceTableScan) {
            lookupStrategy = null;
        } else {
            SubordTableLookupStrategyFactory lookupStrategyFactory = SubordinateTableLookupStrategyUtil.getLookupStrategy(outerStreamTypes, hashKeys, hashKeyCoercionTypes, rangeKeys, rangeKeyCoercionTypes, isNWOnTrigger);
            lookupStrategy = lookupStrategyFactory.makeStrategy(eventTable);
        }
        return new Pair<Object, EventTableAndNamePair>(lookupStrategy, eventTableAndName);
    }

    private Pair<NamedWindowLookupStrategy, EventTableAndNamePair> getStrategyPair(String accessedByStatementName, String accessedByStatementId, Annotation[] accessedByStmtAnnotations, ExprNode joinExpr, EventType filterEventType, IndexHint optionalIndexHint, boolean isIndexShare, int subqueryNumber) {
        EventType[] allStreamsZeroIndexed = new EventType[]{this.rootView.getEventType(), filterEventType};
        EventType[] outerStreams = new EventType[]{filterEventType};
        SubordPropPlan joinedPropPlan = QueryPlanIndexBuilder.getJoinProps(joinExpr, 1, allStreamsZeroIndexed);
        if (joinExpr == null && !this.isVirtualDataWindow()) {
            return new Pair<NamedWindowLookupStrategyAllRows, Object>(new NamedWindowLookupStrategyAllRows(this.dataWindowContents), null);
        }
        Pair<SubordTableLookupStrategy, EventTableAndNamePair> lookupPair = this.getSubqueryStrategyPair(accessedByStatementName, accessedByStatementId, accessedByStmtAnnotations, outerStreams, joinedPropPlan, true, false, optionalIndexHint, isIndexShare, subqueryNumber);
        if (lookupPair == null) {
            return new Pair<NamedWindowLookupStrategyTableScan, Object>(new NamedWindowLookupStrategyTableScan(joinExpr.getExprEvaluator(), this.dataWindowContents), null);
        }
        if (joinExpr == null) {
            return new Pair<NamedWindowLookupStrategy, EventTableAndNamePair>(new NamedWindowLookupStrategyIndexedUnfiltered(lookupPair.getFirst()), lookupPair.getSecond());
        }
        return new Pair<NamedWindowLookupStrategy, EventTableAndNamePair>(new NamedWindowLookupStrategyIndexed(joinExpr.getExprEvaluator(), lookupPair.getFirst()), lookupPair.getSecond());
    }

    public void removeExplicitIndex(String indexName) {
        EventTable table = this.explicitIndexes.remove(indexName);
        if (table != null) {
            this.indexRepository.removeTableReference(table);
        }
    }

    public SubordTableLookupStrategy getAddSubqueryLookupStrategy(String accessedByStatementName, String accessedByStatementId, Annotation[] accessedByStmtAnnotations, EventType[] eventTypesPerStream, SubordPropPlan joinDesc, boolean fullTableScan, int subqueryNum, IndexHint optionalIndexHint) {
        Pair<SubordTableLookupStrategy, EventTableAndNamePair> strategyTablePair = this.getSubqueryStrategyPair(accessedByStatementName, accessedByStatementId, accessedByStmtAnnotations, eventTypesPerStream, joinDesc, false, fullTableScan, optionalIndexHint, this.rootView.isEnableIndexShare(), subqueryNum);
        if (strategyTablePair == null || strategyTablePair.getFirst() == null) {
            if (this.rootView.isQueryPlanLogging()) {
                NamedWindowRootViewInstance namedWindowRootViewInstance = this;
                if (namedWindowRootViewInstance.rootView.getQueryPlanLog().isInfoEnabled()) {
                    NamedWindowRootViewInstance namedWindowRootViewInstance2 = this;
                    namedWindowRootViewInstance2.rootView.getQueryPlanLog().info((Object)"shared, full table scan");
                }
            }
            return new SubordFullTableScanLookupStrategyLocking(this.dataWindowContents, this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock());
        }
        SubordIndexedTableLookupStrategyLocking locking = new SubordIndexedTableLookupStrategyLocking(strategyTablePair.getFirst(), this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock());
        this.tablePerSingleLookup.put(locking, strategyTablePair.getSecond().getEventTable());
        if (this.rootView.isQueryPlanLogging()) {
            NamedWindowRootViewInstance namedWindowRootViewInstance = this;
            if (namedWindowRootViewInstance.rootView.getQueryPlanLog().isInfoEnabled()) {
                String prefix = "Subquery " + subqueryNum + " ";
                String indexName = strategyTablePair.getSecond().getIndexName();
                String indexText = indexName != null ? "index " + indexName + " " : "(implicit) ";
                NamedWindowRootViewInstance namedWindowRootViewInstance3 = this;
                namedWindowRootViewInstance3.rootView.getQueryPlanLog().info((Object)(prefix + "shared index"));
                NamedWindowRootViewInstance namedWindowRootViewInstance4 = this;
                namedWindowRootViewInstance4.rootView.getQueryPlanLog().info((Object)(prefix + "strategy " + strategyTablePair.getFirst().toQueryPlan()));
                NamedWindowRootViewInstance namedWindowRootViewInstance5 = this;
                namedWindowRootViewInstance5.rootView.getQueryPlanLog().info((Object)(prefix + indexText + "table " + strategyTablePair.getSecond().getEventTable().toQueryPlan()));
                QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(accessedByStmtAnnotations);
                if (hook != null) {
                    hook.subquery(new QueryPlanIndexDescSubquery(strategyTablePair.getSecond().getIndexName(), strategyTablePair.getSecond().getEventTable().getClass().getSimpleName(), subqueryNum));
                }
            }
        }
        return locking;
    }

    public void removeSubqueryLookupStrategy(SubordTableLookupStrategy namedWindowSubqueryLookup) {
        EventTable table = this.tablePerSingleLookup.remove(namedWindowSubqueryLookup);
        if (table != null) {
            this.indexRepository.removeTableReference(table);
        }
    }

    private DoubleRange getDoubleRange(boolean reverse, Object start, Object end) {
        if (start == null || end == null) {
            return null;
        }
        double startDbl = ((Number)start).doubleValue();
        double endDbl = ((Number)end).doubleValue();
        if (reverse) {
            return new DoubleRange(startDbl, endDbl);
        }
        return new DoubleRange(endDbl, startDbl);
    }

    public boolean isVirtualDataWindow() {
        return this.getViews()[0] instanceof VirtualDWView;
    }

    public VirtualDWView getVirtualDataWindow() {
        if (!this.isVirtualDataWindow()) {
            return null;
        }
        return (VirtualDWView)((Object)this.getViews()[0]);
    }

    public void postLoad() {
        EventBean[] events = new EventBean[1];
        Iterator<EventBean> i$ = this.dataWindowContents.iterator();
        while (i$.hasNext()) {
            EventBean event;
            events[0] = event = i$.next();
            for (EventTable table : this.indexRepository.getTables()) {
                table.add(events);
            }
        }
    }
}

