/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventPropertyWriter;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NamedWindowUpdateHelper {
    private static final Log log = LogFactory.getLog(NamedWindowUpdateHelper.class);
    private final ExprEvaluator[] expressions;
    private final String[] propertyNames;
    private final EventPropertyWriter[] writers;
    private final EventBeanCopyMethod copyMethod;
    private final boolean[] notNullableField;
    private final TypeWidener[] wideners;

    public NamedWindowUpdateHelper(ExprEvaluator[] expressions, String[] propertyNames, EventPropertyWriter[] writers, EventBeanCopyMethod copyMethod, boolean[] notNullableField, TypeWidener[] wideners) {
        this.expressions = expressions;
        this.propertyNames = propertyNames;
        this.writers = writers;
        this.copyMethod = copyMethod;
        this.notNullableField = notNullableField;
        this.wideners = wideners;
    }

    public static NamedWindowUpdateHelper make(String namedWindowName, EventTypeSPI eventTypeSPI, List<OnTriggerSetAssignment> assignments, String namedWindowAlias) throws ExprValidationException {
        TypeWidener[] wideners = new TypeWidener[assignments.size()];
        ArrayList<String> properties = new ArrayList<String>();
        int len = assignments.size();
        ExprEvaluator[] expressions = new ExprEvaluator[len];
        EventPropertyWriter[] writers = new EventPropertyWriter[len];
        boolean[] notNullableField = new boolean[len];
        for (int i = 0; i < assignments.size(); ++i) {
            OnTriggerSetAssignment assignment = assignments.get(i);
            String propertyName = assignment.getVariableName();
            expressions[i] = assignment.getExpression().getExprEvaluator();
            EventPropertyDescriptor writableProperty = eventTypeSPI.getWritableProperty(propertyName);
            if (writableProperty == null) {
                String name;
                String prefix;
                int indexDot = propertyName.indexOf(".");
                if (namedWindowAlias != null && indexDot != -1) {
                    prefix = propertyName.substring(0, indexDot);
                    name = propertyName.substring(indexDot + 1);
                    if (prefix.equals(namedWindowAlias)) {
                        writableProperty = eventTypeSPI.getWritableProperty(name);
                        propertyName = name;
                    }
                }
                if (writableProperty == null && indexDot != -1) {
                    prefix = propertyName.substring(0, indexDot);
                    name = propertyName.substring(indexDot + 1);
                    if (prefix.equals(namedWindowName)) {
                        writableProperty = eventTypeSPI.getWritableProperty(name);
                        propertyName = name;
                    }
                }
                if (writableProperty == null) {
                    throw new ExprValidationException("Property '" + propertyName + "' is not available for write access");
                }
            }
            writers[i] = eventTypeSPI.getWriter(propertyName);
            notNullableField[i] = writableProperty.getPropertyType().isPrimitive();
            properties.add(propertyName);
            wideners[i] = TypeWidenerFactory.getCheckPropertyAssignType(assignment.getExpression().toExpressionString(), assignment.getExpression().getExprEvaluator().getType(), writableProperty.getPropertyType(), propertyName);
        }
        String[] propertyNames = properties.toArray(new String[properties.size()]);
        ArrayList propertiesUniqueList = new ArrayList(new HashSet(properties));
        String[] propertiesArray = propertiesUniqueList.toArray(new String[propertiesUniqueList.size()]);
        EventBeanCopyMethod copyMethod = eventTypeSPI.getCopyMethod(propertiesArray);
        if (copyMethod == null) {
            throw new ExprValidationException("Event type does not support event bean copy");
        }
        return new NamedWindowUpdateHelper(expressions, propertyNames, writers, copyMethod, notNullableField, wideners);
    }

    public EventBean update(EventBean matchingEvent, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean copy;
        eventsPerStream[0] = copy = this.copyMethod.copy(matchingEvent);
        eventsPerStream[2] = matchingEvent;
        for (int i = 0; i < this.expressions.length; ++i) {
            Object result = this.expressions[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (result == null && this.notNullableField[i]) {
                log.warn((Object)("Null value returned by expression for assignment to property '" + this.propertyNames[i] + " is ignored as the property type is not nullable for expression"));
                continue;
            }
            if (this.wideners[i] != null) {
                result = this.wideners[i].widen(result);
            }
            this.writers[i].write(result, copy);
        }
        return copy;
    }
}

