/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.epl.expression.ExprChainedSpec;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTExprHelper;
import com.espertech.esper.epl.parse.ASTFilterSpecHelper;
import com.espertech.esper.epl.parse.ASTLibHelper;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.spec.ContextDetail;
import com.espertech.esper.epl.spec.ContextDetailCategory;
import com.espertech.esper.epl.spec.ContextDetailCategoryItem;
import com.espertech.esper.epl.spec.ContextDetailCondition;
import com.espertech.esper.epl.spec.ContextDetailConditionCrontab;
import com.espertech.esper.epl.spec.ContextDetailConditionFilter;
import com.espertech.esper.epl.spec.ContextDetailConditionPattern;
import com.espertech.esper.epl.spec.ContextDetailConditionTimePeriod;
import com.espertech.esper.epl.spec.ContextDetailHash;
import com.espertech.esper.epl.spec.ContextDetailHashItem;
import com.espertech.esper.epl.spec.ContextDetailInitiatedTerminated;
import com.espertech.esper.epl.spec.ContextDetailNested;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.ContextDetailPartitioned;
import com.espertech.esper.epl.spec.CreateContextDesc;
import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.epl.spec.PropertyEvalSpec;
import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASTContextHelper {
    private static final Log log = LogFactory.getLog(ASTContextHelper.class);

    public static CreateContextDesc walkCreateContext(Tree parent, Map<Tree, ExprNode> astExprNodeMap, Map<Tree, EvalFactoryNode> astPatternNodeMap, PropertyEvalSpec propertyEvalSpec, FilterSpecRaw filterSpec) {
        ContextDetail contextDetail;
        String contextName = parent.getChild(0).getText();
        Tree detailParent = parent.getChild(1);
        if (detailParent.getType() == 285 || detailParent.getType() == 281) {
            ContextDetailCondition startEndpoint = ASTContextHelper.getContextCondition(detailParent.getChild(0), astExprNodeMap, astPatternNodeMap, propertyEvalSpec);
            ContextDetailCondition endEndpoint = ASTContextHelper.getContextCondition(detailParent.getChild(1), astExprNodeMap, astPatternNodeMap, propertyEvalSpec);
            boolean overlapping = detailParent.getType() == 285;
            contextDetail = new ContextDetailInitiatedTerminated(startEndpoint, endEndpoint, overlapping);
        } else if (detailParent.getType() == 284) {
            ArrayList<ContextDetailCategoryItem> items = new ArrayList<ContextDetailCategoryItem>();
            for (int i = 0; i < detailParent.getChildCount() - 1; ++i) {
                Tree categoryParent = detailParent.getChild(i);
                ExprNode exprNode = astExprNodeMap.remove(categoryParent.getChild(0));
                String name = categoryParent.getChild(1).getText();
                items.add(new ContextDetailCategoryItem(exprNode, name));
            }
            filterSpec = ASTExprHelper.walkFilterSpec(detailParent.getChild(detailParent.getChildCount() - 1), propertyEvalSpec, astExprNodeMap);
            contextDetail = new ContextDetailCategory(items, filterSpec);
        } else if (detailParent.getType() == 282) {
            ArrayList<ContextDetailPartitionItem> rawSpecs = new ArrayList<ContextDetailPartitionItem>();
            for (int i = 0; i < detailParent.getChildCount(); ++i) {
                Tree partitionParent = detailParent.getChild(i);
                filterSpec = ASTExprHelper.walkFilterSpec(partitionParent.getChild(0), propertyEvalSpec, astExprNodeMap);
                propertyEvalSpec = null;
                ArrayList<String> propertyNames = new ArrayList<String>();
                for (int j = 1; j < partitionParent.getChildCount(); ++j) {
                    String propertyName = ASTFilterSpecHelper.getPropertyName(partitionParent.getChild(j), 0);
                    propertyNames.add(propertyName);
                }
                rawSpecs.add(new ContextDetailPartitionItem(filterSpec, propertyNames));
            }
            contextDetail = new ContextDetailPartitioned(rawSpecs);
        } else if (detailParent.getType() == 283) {
            String preallocateStr;
            ArrayList<ContextDetailHashItem> rawSpecs = new ArrayList<ContextDetailHashItem>();
            int count = 0;
            for (int i = 0; i < detailParent.getChildCount(); ++i) {
                Tree hashItemParent = detailParent.getChild(i);
                if (hashItemParent.getType() != 22) continue;
                ++count;
                ExprChainedSpec func = ASTLibHelper.getLibFunctionChainSpec(hashItemParent.getChild(0), astExprNodeMap);
                filterSpec = ASTExprHelper.walkFilterSpec(hashItemParent.getChild(1), propertyEvalSpec, astExprNodeMap);
                propertyEvalSpec = null;
                rawSpecs.add(new ContextDetailHashItem(func, filterSpec));
            }
            String granularity = detailParent.getChild(count).getText();
            if (!granularity.toLowerCase().equals("granularity")) {
                throw new ASTWalkException("Expected 'granularity' keyword after list of coalesce items, found '" + granularity + "' instead");
            }
            Number num = (Number)ASTConstantHelper.parse(detailParent.getChild(count + 1));
            String string = preallocateStr = detailParent.getChildCount() - 1 < count + 2 ? null : detailParent.getChild(count + 2).getText();
            if (preallocateStr != null && !preallocateStr.toLowerCase().equals("preallocate")) {
                throw new ASTWalkException("Expected 'preallocate' keyword after list of coalesce items, found '" + preallocateStr + "' instead");
            }
            if (!JavaClassHelper.isNumericNonFP(num.getClass()) || JavaClassHelper.getBoxedType(num.getClass()) == Long.class) {
                throw new ASTWalkException("Granularity provided must be an int-type number, received " + num.getClass() + " instead");
            }
            contextDetail = new ContextDetailHash(rawSpecs, num.intValue(), preallocateStr != null);
        } else if (detailParent.getType() == 287) {
            ArrayList<CreateContextDesc> contexts = new ArrayList<CreateContextDesc>();
            for (int i = 0; i < detailParent.getChildCount(); ++i) {
                Tree parentCreate = detailParent.getChild(i);
                if (parentCreate.getType() != 280) {
                    throw new IllegalStateException("Child to nested context is not a context-create but type " + parentCreate.getType());
                }
                contexts.add(ASTContextHelper.walkCreateContext(parentCreate, astExprNodeMap, astPatternNodeMap, propertyEvalSpec, filterSpec));
            }
            contextDetail = new ContextDetailNested(contexts);
        } else {
            throw new IllegalStateException("Unrecognized context detail type '" + detailParent.getType() + "'");
        }
        return new CreateContextDesc(contextName, contextDetail);
    }

    private static ContextDetailCondition getContextCondition(Tree parent, Map<Tree, ExprNode> astExprNodeMap, Map<Tree, EvalFactoryNode> astPatternNodeMap, PropertyEvalSpec propertyEvalSpec) {
        if (parent.getType() == 194) {
            List<ExprNode> crontab = ASTExprHelper.getRemoveAllChildExpr(parent, astExprNodeMap);
            return new ContextDetailConditionCrontab(crontab);
        }
        if (parent.getType() == 288) {
            EvalFactoryNode evalNode = astPatternNodeMap.remove(parent.getChild(0).getChild(0));
            boolean inclusive = false;
            if (parent.getChildCount() > 1) {
                String ident = parent.getChild(1).getText();
                if (ident != null && !ident.toLowerCase().equals("inclusive")) {
                    throw new ASTWalkException("Expected 'inclusive' keyword after '@', found '" + ident + "' instead");
                }
                inclusive = true;
            }
            return new ContextDetailConditionPattern(evalNode, inclusive);
        }
        if (parent.getType() == 174) {
            FilterSpecRaw filterSpecRaw = ASTExprHelper.walkFilterSpec(parent.getChild(0), propertyEvalSpec, astExprNodeMap);
            String asName = parent.getChildCount() > 1 ? parent.getChild(1).getText() : null;
            return new ContextDetailConditionFilter(filterSpecRaw, asName);
        }
        if (parent.getType() == 117) {
            ExprTimePeriod timePeriod = (ExprTimePeriod)astExprNodeMap.remove(parent.getChild(0));
            return new ContextDetailConditionTimePeriod(timePeriod);
        }
        throw new IllegalStateException("Unrecognized child type " + parent.getType());
    }
}

