/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.expression.ExprTimePeriodImpl;
import com.espertech.esper.epl.parse.ASTFilterSpecHelper;
import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.PropertyEvalSpec;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.tree.Tree;

public class ASTExprHelper {
    public static ExprNode getRemoveExpr(Tree child, Map<Tree, ExprNode> astExprNodeMap) {
        ExprNode thisEvalNode = astExprNodeMap.get(child);
        astExprNodeMap.remove(child);
        return thisEvalNode;
    }

    public static String getExpressionText(CommonTokenStream tokenStream, Tree node) {
        int startIndex = node.getTokenStartIndex();
        int stopIndex = node.getTokenStopIndex();
        return tokenStream.toString(startIndex, stopIndex);
    }

    public static List<ExprNode> getRemoveAllChildExpr(Tree parent, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<ExprNode> expressions = new ArrayList<ExprNode>(parent.getChildCount());
        for (int i = 0; i < parent.getChildCount(); ++i) {
            expressions.add(astExprNodeMap.remove(parent.getChild(i)));
        }
        return expressions;
    }

    public static FilterSpecRaw walkFilterSpec(Tree node, PropertyEvalSpec propertyEvalSpec, Map<Tree, ExprNode> astExprNodeMap) {
        int count = 0;
        Tree startNode = node.getChild(0);
        if (startNode.getType() == 325) {
            startNode = node.getChild(++count);
        }
        String eventName = startNode.getText();
        if (node.getChildCount() > ++count && node.getChild(count).getType() == 140) {
            ++count;
        }
        List<ExprNode> exprNodes = ASTExprHelper.getExprNodes(node, count, astExprNodeMap);
        return new FilterSpecRaw(eventName, exprNodes, propertyEvalSpec);
    }

    public static List<ExprNode> getExprNodes(Tree parentNode, int startIndex, Map<Tree, ExprNode> astExprNodeMap) {
        LinkedList<ExprNode> exprNodes = new LinkedList<ExprNode>();
        for (int i = startIndex; i < parentNode.getChildCount(); ++i) {
            Tree currentNode = parentNode.getChild(i);
            ExprNode exprNode = astExprNodeMap.get(currentNode);
            if (exprNode == null) {
                throw new IllegalStateException("Expression node for AST node not found for type " + currentNode.getType() + " and text " + currentNode.getText());
            }
            exprNodes.add(exprNode);
            astExprNodeMap.remove(currentNode);
        }
        return exprNodes;
    }

    public static ExprTimePeriod getTimePeriodExpr(Tree node, Map<Tree, ExprNode> astExprNodeMap) {
        ExprNode[] nodes = new ExprNode[8];
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            if (child.getType() == 214) {
                nodes[7] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 213) {
                nodes[6] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 212) {
                nodes[5] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 211) {
                nodes[4] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 210) {
                nodes[3] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 209) {
                nodes[2] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 208) {
                nodes[1] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() != 207) continue;
            nodes[0] = astExprNodeMap.remove(child.getChild(0));
        }
        ExprTimePeriodImpl timeNode = new ExprTimePeriodImpl(nodes[0] != null, nodes[1] != null, nodes[2] != null, nodes[3] != null, nodes[4] != null, nodes[5] != null, nodes[6] != null, nodes[7] != null);
        if (nodes[0] != null) {
            timeNode.addChildNode(nodes[0]);
        }
        if (nodes[1] != null) {
            timeNode.addChildNode(nodes[1]);
        }
        if (nodes[2] != null) {
            timeNode.addChildNode(nodes[2]);
        }
        if (nodes[3] != null) {
            timeNode.addChildNode(nodes[3]);
        }
        if (nodes[4] != null) {
            timeNode.addChildNode(nodes[4]);
        }
        if (nodes[5] != null) {
            timeNode.addChildNode(nodes[5]);
        }
        if (nodes[6] != null) {
            timeNode.addChildNode(nodes[6]);
        }
        if (nodes[7] != null) {
            timeNode.addChildNode(nodes[7]);
        }
        return timeNode;
    }

    protected static List<OnTriggerSetAssignment> getOnTriggerSetAssignments(Tree node, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<OnTriggerSetAssignment> assignments = new ArrayList<OnTriggerSetAssignment>();
        if (node == null) {
            return assignments;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 267) continue;
            Tree childNode = node.getChild(i);
            String variableName = ASTFilterSpecHelper.getPropertyName(childNode.getChild(0), 0);
            ExprNode childEvalNode = astExprNodeMap.get(childNode.getChild(1));
            astExprNodeMap.remove(childNode.getChild(1));
            assignments.add(new OnTriggerSetAssignment(variableName, childEvalNode));
        }
        return assignments;
    }
}

