/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.parse.ASTAnnotationHelper;
import com.espertech.esper.epl.parse.ASTCreateSchemaHelper;
import com.espertech.esper.epl.spec.AnnotationDesc;
import com.espertech.esper.epl.spec.CreateDataFlowDesc;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import com.espertech.esper.epl.spec.GraphOperatorDetail;
import com.espertech.esper.epl.spec.GraphOperatorInput;
import com.espertech.esper.epl.spec.GraphOperatorInputNamesAlias;
import com.espertech.esper.epl.spec.GraphOperatorOutput;
import com.espertech.esper.epl.spec.GraphOperatorOutputItem;
import com.espertech.esper.epl.spec.GraphOperatorOutputItemType;
import com.espertech.esper.epl.spec.GraphOperatorSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASTGraphHelper {
    private static final Log log = LogFactory.getLog(ASTGraphHelper.class);

    public static CreateDataFlowDesc walkCreateDataFlow(Tree parent, Map<Tree, Object> astGraphNodeMap, EngineImportService engineImportService) {
        String graphName = parent.getChild(0).getText();
        ArrayList<GraphOperatorSpec> ops = new ArrayList<GraphOperatorSpec>();
        ArrayList<CreateSchemaDesc> schemas = new ArrayList<CreateSchemaDesc>();
        for (int i = 1; i < parent.getChildCount(); ++i) {
            Tree child = parent.getChild(i);
            if (child.getType() == 268) {
                schemas.add(ASTCreateSchemaHelper.walkCreateSchema(child));
                continue;
            }
            ops.add(ASTGraphHelper.parseOp(child, astGraphNodeMap, engineImportService));
        }
        return new CreateDataFlowDesc(graphName, ops, schemas);
    }

    private static GraphOperatorSpec parseOp(Tree parent, Map<Tree, Object> astGraphNodeMap, EngineImportService engineImportService) {
        List<AnnotationDesc> annotations;
        List<Tree> annotationsTrees;
        int current = 0;
        String operatorName = parent.getChild(current++).getText();
        GraphOperatorInput input = new GraphOperatorInput();
        if (parent.getChildCount() > current && parent.getChild(current).getType() == 291) {
            ASTGraphHelper.parseParams(parent.getChild(current), input);
            ++current;
        }
        GraphOperatorOutput output = new GraphOperatorOutput();
        if (parent.getChildCount() > current && parent.getChild(current).getType() == 293) {
            ASTGraphHelper.parseOutput(parent.getChild(current), output);
            ++current;
        }
        GraphOperatorDetail detail = null;
        if (parent.getChildCount() > current && parent.getChild(current).getType() == 296) {
            Tree detailRoot = parent.getChild(current);
            LinkedHashMap<String, Object> configs = new LinkedHashMap<String, Object>();
            for (int i = 0; i < detailRoot.getChildCount(); ++i) {
                Tree itemRoot = detailRoot.getChild(i);
                Object value = astGraphNodeMap.remove(itemRoot);
                String name = itemRoot.getType() == 297 ? itemRoot.getChild(0).getText() : "select";
                configs.put(name, value);
            }
            detail = new GraphOperatorDetail(configs);
        }
        if (!(annotationsTrees = ASTUtil.findAllNodes(parent, 259)).isEmpty()) {
            annotations = new ArrayList();
            for (Tree tree : annotationsTrees) {
                annotations.add(ASTAnnotationHelper.walk(tree, engineImportService));
            }
        } else {
            annotations = Collections.emptyList();
        }
        return new GraphOperatorSpec(operatorName, input, output, detail, annotations);
    }

    private static void parseParams(Tree paramsRoot, GraphOperatorInput input) {
        for (int i = 0; i < paramsRoot.getChildCount(); ++i) {
            Tree child = paramsRoot.getChild(i);
            if (child.getType() != 292) continue;
            String[] streamNames = ASTGraphHelper.parseParamsStreamNames(child);
            String aliasName = child.getChild(child.getChildCount() - 1).getType() == 17 ? child.getChild(child.getChildCount() - 1).getChild(0).getText() : null;
            input.getStreamNamesAndAliases().add(new GraphOperatorInputNamesAlias(streamNames, aliasName));
        }
    }

    private static String[] parseParamsStreamNames(Tree paramsRoot) {
        ArrayList<String> paramNames = new ArrayList<String>(1);
        for (int i = 0; i < paramsRoot.getChildCount(); ++i) {
            Tree child = paramsRoot.getChild(i);
            if (child.getType() != 153) continue;
            paramNames.add(child.getText());
        }
        return paramNames.toArray(new String[paramNames.size()]);
    }

    private static void parseOutput(Tree outputRoot, GraphOperatorOutput output) {
        for (int i = 0; i < outputRoot.getChildCount(); ++i) {
            Tree child = outputRoot.getChild(i);
            if (child.getType() != 294) continue;
            String streamName = child.getChild(0).getText();
            ArrayList<GraphOperatorOutputItemType> types = new ArrayList<GraphOperatorOutputItemType>();
            for (int childRootId = 1; childRootId < child.getChildCount(); ++childRootId) {
                GraphOperatorOutputItemType type = ASTGraphHelper.parseType(child.getChild(childRootId));
                types.add(type);
            }
            output.getItems().add(new GraphOperatorOutputItem(streamName, types));
        }
    }

    private static GraphOperatorOutputItemType parseType(Tree typeRoot) {
        if (typeRoot.getChild(0).getType() == 340) {
            return new GraphOperatorOutputItemType(true, null, null);
        }
        String className = typeRoot.getChild(0).getText();
        ArrayList<GraphOperatorOutputItemType> typeParams = new ArrayList<GraphOperatorOutputItemType>();
        for (int childRootId = 1; childRootId < typeRoot.getChildCount(); ++childRootId) {
            GraphOperatorOutputItemType type = ASTGraphHelper.parseType(typeRoot.getChild(childRootId));
            typeParams.add(type);
        }
        return new GraphOperatorOutputItemType(false, className, typeParams);
    }
}

