/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTWalkException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;

public class ASTJsonHelper {
    public static Object walk(Tree node) throws ASTWalkException {
        if (node.getType() == 320) {
            return ASTJsonHelper.walkObject(node);
        }
        if (node.getType() == 321) {
            return ASTJsonHelper.walkArray(node);
        }
        if (node.getType() == 304) {
            return ASTJsonHelper.extractString(node.getText());
        }
        return ASTConstantHelper.parse(node);
    }

    private static String extractString(String text) {
        int slashIndex;
        StringBuffer sb = new StringBuffer(text);
        int startPoint = 1;
        while ((slashIndex = sb.indexOf("\\", startPoint)) != -1) {
            char escapeType = sb.charAt(slashIndex + 1);
            switch (escapeType) {
                case 'u': {
                    String unicode = ASTJsonHelper.extractUnicode(sb, slashIndex);
                    sb.replace(slashIndex, slashIndex + 6, unicode);
                    break;
                }
                case 'b': {
                    sb.replace(slashIndex, slashIndex + 2, "\b");
                    break;
                }
                case 't': {
                    sb.replace(slashIndex, slashIndex + 2, "\t");
                    break;
                }
                case 'n': {
                    sb.replace(slashIndex, slashIndex + 2, "\n");
                    break;
                }
                case 'f': {
                    sb.replace(slashIndex, slashIndex + 2, "\f");
                    break;
                }
                case 'r': {
                    sb.replace(slashIndex, slashIndex + 2, "\r");
                    break;
                }
                case '\'': {
                    sb.replace(slashIndex, slashIndex + 2, "'");
                    break;
                }
                case '\"': {
                    sb.replace(slashIndex, slashIndex + 2, "\"");
                    break;
                }
                case '\\': {
                    sb.replace(slashIndex, slashIndex + 2, "\\");
                    break;
                }
                case '/': {
                    sb.replace(slashIndex, slashIndex + 2, "/");
                    break;
                }
            }
            startPoint = slashIndex + 1;
        }
        sb.deleteCharAt(0);
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static String extractUnicode(StringBuffer sb, int slashIndex) {
        String result;
        String code = sb.substring(slashIndex + 2, slashIndex + 6);
        int charNum = Integer.parseInt(code, 16);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            osw.write(charNum);
            osw.flush();
            result = baos.toString("UTF-8");
        }
        catch (Exception e) {
            throw new ASTWalkException("Failed to obtain for unicode '" + charNum + "'");
        }
        return result;
    }

    private static Map<String, Object> walkObject(Tree node) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            if (child.getType() != 322) {
                throw new IllegalStateException("Unexpected node type " + child.getType() + " at text " + child.getText());
            }
            Pair<String, Object> value = ASTJsonHelper.walkJSONField(child);
            map.put(value.getFirst(), value.getSecond());
        }
        return map;
    }

    private static List<Object> walkArray(Tree node) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Object value = ASTJsonHelper.walk(node.getChild(i));
            list.add(value);
        }
        return list;
    }

    private static Pair<String, Object> walkJSONField(Tree node) {
        String name = node.getChild(0).getType() == 304 || node.getChild(0).getType() == 343 || node.getChild(0).getType() == 344 ? ASTJsonHelper.extractString(node.getChild(0).getText()) : node.getChild(0).getText();
        Object value = ASTJsonHelper.walk(node.getChild(1));
        return new Pair<String, Object>(name, value);
    }
}

