/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.epl.expression.ExprChainedSpec;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;

public class ASTLibHelper {
    public static ExprChainedSpec getLibFunctionChainSpec(Tree libFunctionParent, Map<Tree, ExprNode> astExprNodeMap) {
        if (libFunctionParent.getType() != 201) {
            throw new IllegalArgumentException("Not a LIB_FUNCTION parent");
        }
        int count = 0;
        if (libFunctionParent.getChild(0).getType() == 153) {
            ++count;
        }
        String methodName = ASTConstantHelper.removeTicks(libFunctionParent.getChild(count).getText());
        List<ExprNode> parameters = ASTLibHelper.getExprNodesLibFunc(++count, libFunctionParent, astExprNodeMap);
        boolean isProperty = libFunctionParent.getChildCount() > 0 && libFunctionParent.getChild(libFunctionParent.getChildCount() - 1).getType() != 326;
        return new ExprChainedSpec(methodName, parameters, isProperty);
    }

    public static List<ExprNode> getExprNodesLibFunc(int start, Tree parent, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<ExprNode> parameters = new ArrayList<ExprNode>();
        for (int exprNum = start; exprNum < parent.getChildCount(); ++exprNum) {
            if (parent.getChild(exprNum).getType() == 331) {
                ExprLambdaGoesNode goes = ASTLibHelper.getLambdaGoes(parent.getChild(exprNum));
                ExprNode lambdaExpr = astExprNodeMap.remove(parent.getChild(++exprNum));
                goes.addChildNode(lambdaExpr);
                parameters.add(goes);
                continue;
            }
            ExprNode parameter = astExprNodeMap.remove(parent.getChild(exprNum));
            if (parameter == null) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    private static ExprLambdaGoesNode getLambdaGoes(Tree child) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (child.getChild(0).getType() == 325) {
            parameters.add(child.getChild(0).getText());
        } else {
            parameters = ASTLibHelper.getIdentList(child.getChild(0));
        }
        return new ExprLambdaGoesNode(parameters);
    }

    public static List<String> getIdentList(Tree node) {
        return ASTLibHelper.getTextList(node, 325);
    }

    public static List<String> getTextList(Tree node, int nodeType) {
        ArrayList<String> columsList = new ArrayList<String>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != nodeType) continue;
            columsList.add(node.getChild(i).getText());
        }
        return columsList;
    }

    public static List<String> getTextListChild(Tree node, int nodeType) {
        ArrayList<String> columsList = new ArrayList<String>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != nodeType) continue;
            columsList.add(node.getChild(i).getChild(0).getText());
        }
        return columsList;
    }
}

