/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.parse.ASTWalkException;

public class ASTMatchUntilHelper {
    public static boolean validate(ExprNode lowerBounds, ExprNode upperBounds, boolean isAllowLowerZero) throws ASTWalkException {
        boolean isConstants = true;
        Object constantLower = null;
        String numericMessage = "Match-until bounds expect a numeric or expression value";
        if (ExprNodeUtility.isConstantValueExpr(lowerBounds)) {
            constantLower = lowerBounds.getExprEvaluator().evaluate(null, true, null);
            if (constantLower == null || !(constantLower instanceof Number)) {
                throw new ASTWalkException(numericMessage);
            }
        } else {
            isConstants = lowerBounds == null;
        }
        Object constantUpper = null;
        if (ExprNodeUtility.isConstantValueExpr(upperBounds)) {
            constantUpper = upperBounds.getExprEvaluator().evaluate(null, true, null);
            if (constantUpper == null || !(constantUpper instanceof Number)) {
                throw new ASTWalkException(numericMessage);
            }
        } else {
            boolean bl = isConstants = isConstants && upperBounds == null;
        }
        if (!isConstants) {
            return true;
        }
        if (constantLower != null && constantUpper != null) {
            Integer lower = ((Number)constantLower).intValue();
            Integer upper = ((Number)constantUpper).intValue();
            if (lower > upper) {
                throw new ASTWalkException("Incorrect range specification, lower bounds value '" + lower + "' is higher then higher bounds '" + upper + "'");
            }
        }
        ASTMatchUntilHelper.verifyConstant(constantLower, isAllowLowerZero);
        ASTMatchUntilHelper.verifyConstant(constantUpper, false);
        return constantLower != null && constantUpper != null && constantLower.equals(constantUpper);
    }

    private static void verifyConstant(Object value, boolean isAllowZero) {
        if (value != null) {
            Integer bound = ((Number)value).intValue();
            if (isAllowZero) {
                if (bound < 0) {
                    throw new ASTWalkException("Incorrect range specification, a bounds value of negative value is not allowed");
                }
            } else if (bound <= 0) {
                throw new ASTWalkException("Incorrect range specification, a bounds value of zero or negative value is not allowed");
            }
        }
    }
}

