/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.antlr.NoCaseSensitiveStream;
import com.espertech.esper.client.EPException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.EPLTreeWalker;
import com.espertech.esper.epl.parse.ExceptionConvertor;
import com.espertech.esper.epl.parse.ParseResult;
import com.espertech.esper.epl.parse.ParseRuleSelector;
import com.espertech.esper.epl.parse.WalkRuleSelector;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParseHelper {
    public static final String newline = System.getProperty("line.separator");
    private static Log log = LogFactory.getLog(ParseHelper.class);

    public static void walk(Tree ast, EPLTreeWalker walker, WalkRuleSelector walkRuleSelector, String expression, String eplStatementForErrorMsg) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(".walk Walking AST using walker " + ((Object)((Object)walker)).getClass().getName()));
            }
            walkRuleSelector.invokeWalkRule(walker);
            if (log.isDebugEnabled()) {
                log.debug((Object)".walk AST tree after walking");
                ASTUtil.dumpAST(ast);
            }
        }
        catch (RuntimeException e) {
            log.info((Object)("Error walking statement [" + expression + "]"), (Throwable)e);
            if (e.getCause() instanceof RecognitionException) {
                throw ExceptionConvertor.convert((RecognitionException)e.getCause(), eplStatementForErrorMsg, walker);
            }
            throw e;
        }
        catch (RecognitionException e) {
            log.info((Object)("Error walking statement [" + expression + "]"), (Throwable)e);
            throw ExceptionConvertor.convert(e, eplStatementForErrorMsg, walker);
        }
    }

    public static ParseResult parse(String expression, String eplStatementErrorMsg, boolean addPleaseCheck, ParseRuleSelector parseRuleSelector, boolean rewriteScript) throws EPException {
        Tree tree;
        NoCaseSensitiveStream input;
        if (log.isDebugEnabled()) {
            log.debug((Object)(".parse Parsing expr=" + expression));
        }
        try {
            input = new NoCaseSensitiveStream(new StringReader(expression));
        }
        catch (IOException ex) {
            throw new EPException("IOException parsing expression '" + expression + '\'', ex);
        }
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer((CharStream)input);
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lex);
        EsperEPL2GrammarParser parser = new EsperEPL2GrammarParser((TokenStream)tokens);
        try {
            tree = parseRuleSelector.invokeParseRule(parser);
        }
        catch (RuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error parsing statement [" + eplStatementErrorMsg + "]"), (Throwable)e);
            }
            if (e.getCause() instanceof RecognitionException) {
                throw ExceptionConvertor.convertStatement((RecognitionException)e.getCause(), eplStatementErrorMsg, addPleaseCheck, parser);
            }
            throw e;
        }
        catch (RecognitionException ex) {
            if (rewriteScript && ParseHelper.isContainsScriptExpression(tokens)) {
                ScriptResult rewriteExpression = ParseHelper.rewriteTokensScript(tokens);
                ParseResult result = ParseHelper.parse(rewriteExpression.getRewrittenEPL(), eplStatementErrorMsg, addPleaseCheck, parseRuleSelector, false);
                return new ParseResult(result.getTree(), result.getExpressionWithoutAnnotations(), result.getTokenStream(), rewriteExpression.getScripts());
            }
            log.debug((Object)("Error parsing statement [" + expression + "]"), (Throwable)ex);
            throw ExceptionConvertor.convertStatement(ex, eplStatementErrorMsg, addPleaseCheck, parser);
        }
        if (rewriteScript && ParseHelper.isContainsScriptExpression(tokens)) {
            ScriptResult rewriteExpression = ParseHelper.rewriteTokensScript(tokens);
            ParseResult result = ParseHelper.parse(rewriteExpression.getRewrittenEPL(), rewriteExpression.getRewrittenEPL(), addPleaseCheck, parseRuleSelector, false);
            return new ParseResult(result.getTree(), result.getExpressionWithoutAnnotations(), result.getTokenStream(), rewriteExpression.getScripts());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)".parse Dumping AST...");
            ASTUtil.dumpAST(tree);
        }
        return new ParseResult(tree, ParseHelper.getNoAnnotation(expression, tree, (CommonTokenStream)tokens), (CommonTokenStream)tokens, Collections.<String>emptyList());
    }

    private static ScriptResult rewriteTokensScript(TokenRewriteStream tokens) {
        ArrayList<String> scripts = new ArrayList<String>();
        for (int i = 0; i < tokens.size(); ++i) {
            int endIndex;
            if (tokens.get(i).getType() != 123) continue;
            Token tokenBefore = ParseHelper.getTokenBefore(i, tokens);
            boolean isCreateExpressionClause = tokenBefore != null && tokenBefore.getType() == 4;
            Pair<String, Integer> nameAndNameStart = ParseHelper.findScriptName(i + 1, tokens);
            int startIndex = ParseHelper.findStartTokenScript(nameAndNameStart.getSecond(), tokens, 323);
            if (startIndex == -1 || (endIndex = ParseHelper.findEndTokenScript(startIndex + 1, tokens, 324, EsperEPL2GrammarParser.getAfterScriptTokens(), !isCreateExpressionClause)) == -1) continue;
            StringWriter writer = new StringWriter();
            for (int j = startIndex + 1; j < endIndex; ++j) {
                writer.append(tokens.get(j).getText());
            }
            scripts.add(writer.toString());
            ParseHelper.rewriteScript(startIndex, endIndex, tokens);
        }
        String rewrittenEPL = tokens.toString();
        return new ScriptResult(rewrittenEPL, scripts);
    }

    private static Token getTokenBefore(int i, TokenRewriteStream tokens) {
        for (int position = i - 1; position >= 0; --position) {
            Token t = tokens.get(position);
            if (t.getChannel() == 99) continue;
            return t;
        }
        return null;
    }

    private static Pair<String, Integer> findScriptName(int start, TokenRewriteStream tokens) {
        String lastIdent = null;
        int lastIdentIndex = 0;
        for (int i = start; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() == 325) {
                lastIdent = tokens.get(i).getText();
                lastIdentIndex = i;
            }
            if (tokens.get(i).getType() == 326 || tokens.get(i).getType() == 323 && tokens.get(i + 1).getType() != 324) break;
        }
        if (lastIdent == null) {
            throw new IllegalStateException("Failed to parse expression name");
        }
        return new Pair<Object, Integer>(lastIdent, lastIdentIndex);
    }

    private static void rewriteScript(int startIndex, int endIndex, TokenRewriteStream tokens) {
        if (startIndex >= endIndex - 1) {
            return;
        }
        Token[] tokensCapture = new Token[endIndex - startIndex - 1];
        int count = 0;
        for (int i = startIndex + 1; i < endIndex; ++i) {
            tokensCapture[count] = tokens.get(i);
            ++count;
        }
        tokens.delete(startIndex + 1, endIndex - 1);
        int start = endIndex - 1;
        tokens.insertAfter(start, (Object)"'");
        for (int i = 0; i < tokensCapture.length; ++i) {
            if (tokensCapture[i].getType() == 344) {
                tokens.insertAfter(start, (Object)"\\'");
                tokens.insertAfter(start, (Object)tokensCapture[i].getText().substring(1, tokensCapture[i].getText().length() - 1));
                tokens.insertAfter(start, (Object)"\\'");
                continue;
            }
            tokens.insertAfter(start, (Object)tokensCapture[i].getText());
        }
        tokens.insertAfter(start, (Object)"'");
    }

    private static int findStartTokenScript(int startIndex, TokenRewriteStream tokens, int tokenTypeSearch) {
        int found = -1;
        for (int i = startIndex; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() != tokenTypeSearch) continue;
            return i;
        }
        return found;
    }

    private static int findEndTokenScript(int startIndex, TokenRewriteStream tokens, int tokenTypeSearch, Set<Integer> afterScriptTokens, boolean requireAfterScriptToken) {
        int found = -1;
        for (int i = startIndex; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() == tokenTypeSearch) {
                if (!requireAfterScriptToken) {
                    return i;
                }
                for (int j = i + 1; j < tokens.size(); ++j) {
                    Token next = tokens.get(j);
                    if (next.getChannel() != 0) continue;
                    if (!afterScriptTokens.contains(next.getType())) break;
                    found = i;
                    break;
                }
            }
            if (found != -1) break;
        }
        return found;
    }

    private static boolean isContainsScriptExpression(TokenRewriteStream tokens) {
        for (int i = 0; i < tokens.size(); ++i) {
            int startIndex;
            if (tokens.get(i).getType() != 123 || (startIndex = ParseHelper.findStartTokenScript(i + 1, tokens, 323)) == -1) continue;
            return true;
        }
        return false;
    }

    private static String getNoAnnotation(String expression, Tree tree, CommonTokenStream tokens) {
        Token lastAnnotationToken = null;
        for (int i = 0; i < tree.getChildCount() && tree.getChild(i).getType() == 259; ++i) {
            lastAnnotationToken = tokens.get(tree.getChild(i).getTokenStopIndex());
        }
        if (lastAnnotationToken == null) {
            return null;
        }
        try {
            int line = lastAnnotationToken.getLine();
            int charpos = lastAnnotationToken.getCharPositionInLine();
            int fromChar = charpos + lastAnnotationToken.getText().length();
            if (line == 1) {
                return expression.substring(fromChar).trim();
            }
            String[] lines = expression.split("\r\n|\r|\n");
            StringBuilder buf = new StringBuilder();
            buf.append(lines[line - 1].substring(fromChar));
            for (int i = line; i < lines.length; ++i) {
                buf.append(lines[i]);
                if (i >= lines.length - 1) continue;
                buf.append(newline);
            }
            return buf.toString().trim();
        }
        catch (RuntimeException ex) {
            log.error((Object)("Error determining non-annotated expression sting: " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    private static class ScriptResult {
        private final String rewrittenEPL;
        private final List<String> scripts;

        private ScriptResult(String rewrittenEPL, List<String> scripts) {
            this.rewrittenEPL = rewrittenEPL;
            this.scripts = scripts;
        }

        public String getRewrittenEPL() {
            return this.rewrittenEPL;
        }

        public List<String> getScripts() {
            return this.scripts;
        }
    }
}

