/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.property;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.property.ContainedEventEval;
import com.espertech.esper.epl.property.PropertyEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyEvaluatorSimple
implements PropertyEvaluator {
    private static final Log log = LogFactory.getLog(PropertyEvaluatorSimple.class);
    private final ContainedEventEval containedEventEval;
    private final FragmentEventType fragmentEventType;
    private final ExprEvaluator filter;
    private final String expressionText;

    public PropertyEvaluatorSimple(ContainedEventEval containedEventEval, FragmentEventType fragmentEventType, ExprEvaluator filter, String expressionText) {
        this.fragmentEventType = fragmentEventType;
        this.containedEventEval = containedEventEval;
        this.filter = filter;
        this.expressionText = expressionText;
    }

    @Override
    public EventBean[] getProperty(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            Object result = this.containedEventEval.getFragment(theEvent, new EventBean[]{theEvent}, exprEvaluatorContext);
            EventBean[] rows = this.fragmentEventType.isIndexed() ? (EventBean[])result : new EventBean[]{(EventBean)result};
            if (this.filter == null) {
                return rows;
            }
            return ExprNodeUtility.applyFilterExpression(this.filter, theEvent, (EventBean[])result, exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            log.error((Object)("Unexpected error evaluating property expression for event of type '" + theEvent.getEventType().getName() + "' and property '" + this.expressionText + "': " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public EventType getFragmentEventType() {
        return this.fragmentEventType.getFragmentType();
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    public ExprEvaluator getFilter() {
        return this.filter;
    }

    @Override
    public boolean compareTo(PropertyEvaluator otherEval) {
        if (!(otherEval instanceof PropertyEvaluatorSimple)) {
            return false;
        }
        PropertyEvaluatorSimple other = (PropertyEvaluatorSimple)otherEval;
        if (!other.getExpressionText().equals(this.getExpressionText())) {
            return false;
        }
        return other.getFilter() == null && this.getFilter() == null;
    }
}

