/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.script;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.script.ExprNodeScript;
import com.espertech.esper.epl.script.ExprNodeScriptEvalBase;
import com.espertech.esper.epl.script.mvel.MVELInvoker;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNodeScriptEvalMVEL
extends ExprNodeScriptEvalBase {
    private static final Log log = LogFactory.getLog(ExprNodeScriptEvalMVEL.class);
    private final Object executable;

    public ExprNodeScriptEvalMVEL(String scriptName, String statementName, String[] names, ExprEvaluator[] parameters, Class returnType, Object executable) {
        super(scriptName, statementName, names, parameters, returnType);
        this.executable = executable;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        HashMap<String, Object> paramsList = new HashMap<String, Object>();
        for (int i = 0; i < this.names.length; ++i) {
            paramsList.put(this.names[i], this.parameters[i].evaluate(eventsPerStream, isNewData, context));
        }
        paramsList.put(ExprNodeScript.CONTEXT_BINDING_NAME, context.getAgentInstanceScriptContext());
        try {
            Object result = MVELInvoker.executeExpression(this.executable, paramsList);
            if (this.coercer != null) {
                return this.coercer.coerceBoxed((Number)result);
            }
            return result;
        }
        catch (InvocationTargetException ex) {
            Throwable mvelException = ex.getCause();
            String message = "Unexpected exception executing script '" + this.scriptName + "' for statement '" + this.statementName + "' : " + mvelException.getMessage();
            log.error((Object)message, mvelException);
            throw new EPException(message, ex);
        }
    }
}

