/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.soda.CreateSchemaClauseTypeDef;
import com.espertech.esper.epl.spec.ColumnDesc;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class CreateSchemaDesc
implements MetaDefItem,
Serializable {
    private static final long serialVersionUID = 8400789369907593190L;
    private final String schemaName;
    private final Set<String> types;
    private final List<ColumnDesc> columns;
    private final Set<String> inherits;
    private final AssignedType assignedType;
    private final String startTimestampProperty;
    private final String endTimestampProperty;
    private final Set<String> copyFrom;

    public CreateSchemaDesc(String schemaName, Set<String> types, List<ColumnDesc> columns, Set<String> inherits, AssignedType assignedType, String startTimestampProperty, String endTimestampProperty, Set<String> copyFrom) {
        this.schemaName = schemaName;
        this.types = types;
        this.columns = columns;
        this.inherits = inherits;
        this.assignedType = assignedType;
        this.startTimestampProperty = startTimestampProperty;
        this.endTimestampProperty = endTimestampProperty;
        this.copyFrom = copyFrom;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public List<ColumnDesc> getColumns() {
        return this.columns;
    }

    public Set<String> getInherits() {
        return this.inherits;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    public AssignedType getAssignedType() {
        return this.assignedType;
    }

    public String getStartTimestampProperty() {
        return this.startTimestampProperty;
    }

    public String getEndTimestampProperty() {
        return this.endTimestampProperty;
    }

    public Set<String> getCopyFrom() {
        return this.copyFrom;
    }

    public static enum AssignedType {
        VARIANT,
        MAP,
        OBJECTARRAY,
        NONE;


        public CreateSchemaClauseTypeDef mapToSoda() {
            if (this == VARIANT) {
                return CreateSchemaClauseTypeDef.VARIANT;
            }
            if (this == MAP) {
                return CreateSchemaClauseTypeDef.MAP;
            }
            if (this == OBJECTARRAY) {
                return CreateSchemaClauseTypeDef.OBJECTARRAY;
            }
            return CreateSchemaClauseTypeDef.NONE;
        }

        public static AssignedType parseKeyword(String keywordNodeText) {
            if (keywordNodeText.toLowerCase().equals("variant")) {
                return VARIANT;
            }
            if (keywordNodeText.toLowerCase().equals("map")) {
                return MAP;
            }
            if (keywordNodeText.toLowerCase().equals("objectarray")) {
                return OBJECTARRAY;
            }
            throw new EPException("Expected 'variant', 'map' or 'objectarray' keyword after create-schema clause but encountered '" + keywordNodeText + "'");
        }

        public static AssignedType mapFrom(CreateSchemaClauseTypeDef typeDefinition) {
            if (typeDefinition == null || CreateSchemaClauseTypeDef.NONE == typeDefinition) {
                return NONE;
            }
            if (CreateSchemaClauseTypeDef.MAP == typeDefinition) {
                return MAP;
            }
            if (CreateSchemaClauseTypeDef.OBJECTARRAY == typeDefinition) {
                return OBJECTARRAY;
            }
            return VARIANT;
        }
    }
}

